/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.spi.UuidGenerator;

public class DefaultUuidGenerator
implements UuidGenerator {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private final char[] seed = (DefaultUuidGenerator.longToHex(new char[0], ThreadLocalRandom.current().nextLong()).substring(1) + "-").toCharArray();
    private final AtomicLong index = new AtomicLong();

    public String generateUuid() {
        return DefaultUuidGenerator.longToHex(this.seed, this.index.getAndIncrement());
    }

    private static String longToHex(char[] seed, long v) {
        int l = seed.length;
        char[] hexChars = new char[16 + seed.length];
        System.arraycopy(seed, 0, hexChars, 0, l);
        for (int j = 15; j >= 0; --j) {
            hexChars[l + j] = HEX_ARRAY[(int)(v & 0xFL)];
            v >>= 4;
        }
        return new String(hexChars);
    }
}

