/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

public class EntityInheritanceTree {
    protected final ObjEntity entity;
    protected EntityInheritanceTree parent;
    protected Collection<EntityInheritanceTree> subentities;
    protected Expression normalizedQualifier;

    public EntityInheritanceTree(ObjEntity entity) {
        this.entity = entity;
    }

    public Expression qualifierForEntityAndSubclasses() {
        Expression qualifier = this.entity.getDeclaredQualifier();
        if (qualifier == null && this.parent == null) {
            return null;
        }
        if (this.subentities != null) {
            for (EntityInheritanceTree child : this.subentities) {
                Expression childQualifier = child.qualifierForEntityAndSubclasses();
                if (childQualifier == null) {
                    return null;
                }
                if (qualifier == null) {
                    qualifier = childQualifier;
                    continue;
                }
                qualifier = qualifier.orExp(childQualifier);
            }
        }
        return qualifier;
    }

    public ObjEntity entityMatchingRow(DataRow row) {
        Expression qualifier;
        if (this.subentities != null) {
            for (EntityInheritanceTree child : this.subentities) {
                ObjEntity matched = child.entityMatchingRow(row);
                if (matched == null) continue;
                return matched;
            }
        }
        if ((qualifier = this.getDbQualifier()) != null) {
            return qualifier.match(row) ? this.entity : null;
        }
        return this.parent == null ? this.entity : null;
    }

    public Expression getDbQualifier() {
        if (this.entity.getDeclaredQualifier() == null) {
            return null;
        }
        if (this.normalizedQualifier == null) {
            this.normalizedQualifier = this.entity.translateToDbPath(this.entity.getDeclaredQualifier());
        }
        return this.normalizedQualifier;
    }

    public void addChildNode(EntityInheritanceTree node) {
        if (this.subentities == null) {
            this.subentities = new ArrayList<EntityInheritanceTree>(2);
        }
        this.subentities.add(node);
        node.parent = this;
    }

    public int getChildrenCount() {
        return this.subentities != null ? this.subentities.size() : 0;
    }

    public Collection<EntityInheritanceTree> getChildren() {
        return this.subentities != null ? this.subentities : Collections.emptyList();
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    public Collection<ObjEntity> allSubEntities() {
        if (this.subentities == null) {
            return Collections.singletonList(this.entity);
        }
        ArrayList<ObjEntity> c = new ArrayList<ObjEntity>();
        this.appendSubentities(c);
        return c;
    }

    private void appendSubentities(Collection<ObjEntity> c) {
        c.add(this.entity);
        if (this.subentities == null) {
            return;
        }
        for (EntityInheritanceTree subentity : this.subentities) {
            subentity.appendSubentities(c);
        }
    }

    public Collection<ObjAttribute> allAttributes() {
        if (this.subentities == null) {
            return this.entity.getAttributes();
        }
        ArrayList<ObjAttribute> c = new ArrayList<ObjAttribute>();
        this.appendDeclaredAttributes(c);
        ObjEntity superEntity = this.entity.getSuperEntity();
        if (superEntity != null) {
            c.addAll(superEntity.getAttributes());
        }
        return c;
    }

    public Collection<ObjRelationship> allRelationships() {
        if (this.subentities == null) {
            return this.entity.getRelationships();
        }
        ArrayList<ObjRelationship> c = new ArrayList<ObjRelationship>();
        this.appendDeclaredRelationships(c);
        ObjEntity superEntity = this.entity.getSuperEntity();
        if (superEntity != null) {
            c.addAll(superEntity.getRelationships());
        }
        return c;
    }

    protected void appendDeclaredAttributes(Collection<ObjAttribute> c) {
        c.addAll(this.entity.getDeclaredAttributes());
        if (this.subentities != null) {
            for (EntityInheritanceTree child : this.subentities) {
                child.appendDeclaredAttributes(c);
            }
        }
    }

    protected void appendDeclaredRelationships(Collection<ObjRelationship> c) {
        c.addAll(this.entity.getDeclaredRelationships());
        if (this.subentities != null) {
            for (EntityInheritanceTree child : this.subentities) {
                child.appendDeclaredRelationships(c);
            }
        }
    }
}

