/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.DBConnectionAwareAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DatabaseSchemaLoader;
import org.apache.cayenne.modeler.editor.dbimport.DbImportModel;
import org.apache.cayenne.modeler.editor.dbimport.DbImportView;
import org.apache.cayenne.modeler.editor.dbimport.DraggableTreePanel;
import org.apache.cayenne.modeler.editor.dbimport.PrintColumnsBiFunction;
import org.apache.cayenne.modeler.editor.dbimport.PrintTablesBiFunction;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadDbSchemaAction
extends DBConnectionAwareAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadDbSchemaAction.class);
    private static final String ICON_NAME = "icon-dbi-refresh.png";
    private static final String ACTION_NAME = "Refresh Db Schema";
    private DraggableTreePanel draggableTreePanel;

    LoadDbSchemaAction(Application application) {
        super(ACTION_NAME, application);
    }

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    @Override
    public void performAction(ActionEvent e) {
        this.performAction(e, null);
    }

    public void performAction(ActionEvent e, TreePath tablePath) {
        DbImportView rootParent = (DbImportView)this.draggableTreePanel.getParent().getParent();
        rootParent.getLoadDbSchemaProgress().setVisible(true);
        rootParent.getLoadDbSchemaButton().setEnabled(false);
        Thread thread = new Thread(() -> {
            this.setEnabled(false);
            rootParent.lockToolbarButtons();
            this.draggableTreePanel.getMoveButton().setEnabled(false);
            this.draggableTreePanel.getMoveInvertButton().setEnabled(false);
            try {
                DBConnectionInfo connectionInfo = this.getConnectionInfo("Load Db Schema");
                if (connectionInfo == null) {
                    return;
                }
                if (tablePath != null) {
                    Object userObject = ((DbImportTreeNode)tablePath.getLastPathComponent()).getUserObject();
                    if (userObject instanceof Catalog) {
                        Catalog catalog = (Catalog)userObject;
                        if (catalog.getSchemas().isEmpty()) {
                            this.loadTables(connectionInfo, tablePath, rootParent);
                        }
                    } else if (userObject instanceof Schema) {
                        this.loadTables(connectionInfo, tablePath, rootParent);
                    } else if (userObject instanceof IncludeTable) {
                        this.loadColumns(connectionInfo, tablePath);
                    } else {
                        this.loadTables(connectionInfo, tablePath, rootParent);
                    }
                } else {
                    this.loadDataBase(connectionInfo);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Application.getFrame(), ex.getMessage(), "Error loading db schema", 0);
                LOGGER.warn("Error loading db schema", ex);
            }
            finally {
                rootParent.getLoadDbSchemaButton().setEnabled(true);
                rootParent.getLoadDbSchemaProgress().setVisible(false);
                rootParent.unlockToolbarButtons();
            }
        });
        thread.start();
    }

    private void loadDataBase(DBConnectionInfo connectionInfo) throws Exception {
        ReverseEngineering databaseReverseEngineering = new DatabaseSchemaLoader().load(connectionInfo, this.getApplication().getClassLoadingService());
        this.draggableTreePanel.getSourceTree().setEnabled(true);
        this.draggableTreePanel.getSourceTree().translateReverseEngineeringToTree(databaseReverseEngineering, true);
        this.draggableTreePanel.bindReverseEngineeringToDatamap(this.getProjectController().getCurrentDataMap(), databaseReverseEngineering);
        ((DbImportModel)this.draggableTreePanel.getSourceTree().getModel()).reload();
    }

    private void loadTables(DBConnectionInfo connectionInfo, TreePath tablePath, DbImportView rootParent) throws Exception {
        ReverseEngineering databaseReverseEngineering = new DatabaseSchemaLoader().loadTables(connectionInfo, this.getApplication().getClassLoadingService(), tablePath, rootParent.getTableTypes());
        this.draggableTreePanel.getSourceTree().update(databaseReverseEngineering, new PrintTablesBiFunction(this.draggableTreePanel.getSourceTree()));
    }

    private void loadColumns(DBConnectionInfo connectionInfo, TreePath tablePath) throws SQLException {
        ReverseEngineering databaseReverseEngineering = new DatabaseSchemaLoader().loadColumns(connectionInfo, this.getApplication().getClassLoadingService(), tablePath);
        this.draggableTreePanel.getSourceTree().update(databaseReverseEngineering, new PrintColumnsBiFunction(this.draggableTreePanel.getSourceTree()));
    }

    public void setDraggableTreePanel(DraggableTreePanel draggableTreePanel) {
        this.draggableTreePanel = draggableTreePanel;
    }
}

