/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Arrays;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public final class ReplicationPrepareMessage
extends PacketImpl {
    private long txId;
    private byte journalID;
    private EncodingSupport encodingData;
    private byte[] recordData;

    public ReplicationPrepareMessage() {
        super((byte)95);
    }

    public ReplicationPrepareMessage(byte journalID, long txId, EncodingSupport encodingData) {
        this();
        this.journalID = journalID;
        this.txId = txId;
        this.encodingData = encodingData;
    }

    public int expectedEncodeSize() {
        return 26 + this.encodingData.getEncodeSize();
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeLong(this.txId);
        buffer.writeInt(this.encodingData.getEncodeSize());
        this.encodingData.encode(buffer);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.txId = buffer.readLong();
        int size = buffer.readInt();
        this.recordData = new byte[size];
        buffer.readBytes(this.recordData);
    }

    public long getTxId() {
        return this.txId;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.encodingData, this.journalID, Arrays.hashCode(this.recordData), this.txId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationPrepareMessage)) {
            return false;
        }
        ReplicationPrepareMessage other = (ReplicationPrepareMessage)((Object)obj);
        return Objects.equals(this.encodingData, other.encodingData) && this.journalID == other.journalID && Arrays.equals(this.recordData, other.recordData) && this.txId == other.txId;
    }
}

