/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.memory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.agents.api.context.MemoryObject;
import org.apache.flink.agents.api.context.MemoryRef;
import org.apache.flink.agents.api.context.MemoryUpdate;
import org.apache.flink.agents.runtime.memory.MemoryStore;

public class MemoryObjectImpl
implements MemoryObject {
    public static final String ROOT_KEY = "";
    private static final String SEPARATOR = ".";
    private final MemoryStore store;
    private final List<MemoryUpdate> memoryUpdates;
    private final String prefix;
    private final Runnable mailboxThreadChecker;

    public MemoryObjectImpl(MemoryStore store, String prefix, List<MemoryUpdate> memoryUpdates) throws Exception {
        this(store, prefix, () -> {}, memoryUpdates);
    }

    public MemoryObjectImpl(MemoryStore store, String prefix, Runnable mailboxThreadChecker, List<MemoryUpdate> memoryUpdates) throws Exception {
        this.store = store;
        this.prefix = prefix;
        this.mailboxThreadChecker = mailboxThreadChecker;
        if (!store.contains(ROOT_KEY)) {
            store.put(ROOT_KEY, new MemoryItem());
        }
        this.memoryUpdates = memoryUpdates;
    }

    @Override
    public MemoryObject get(String path) throws Exception {
        this.mailboxThreadChecker.run();
        String absPath = this.fullPath(path);
        if (this.store.contains(absPath)) {
            return new MemoryObjectImpl(this.store, absPath, this.memoryUpdates);
        }
        return null;
    }

    @Override
    public MemoryObject get(MemoryRef ref) throws Exception {
        return this.get(ref.getPath());
    }

    @Override
    public MemoryRef set(String path, Object value) throws Exception {
        this.mailboxThreadChecker.run();
        String absPath = this.fullPath(path);
        String[] parts = absPath.split("\\.");
        this.fillParents(parts);
        String parent = absPath.contains(SEPARATOR) ? absPath.substring(0, absPath.lastIndexOf(SEPARATOR)) : ROOT_KEY;
        MemoryItem parentItem = this.store.get(parent);
        parentItem.getSubKeys().add(parts[parts.length - 1]);
        this.store.put(parent, parentItem);
        MemoryItem existing = this.store.get(absPath);
        if (existing != null && existing.getType() == ItemType.OBJECT) {
            throw new IllegalArgumentException("Cannot overwrite object with value: " + absPath);
        }
        MemoryItem val = new MemoryItem(value);
        this.store.put(absPath, val);
        this.memoryUpdates.add(new MemoryUpdate(absPath, value));
        return MemoryRef.create(absPath);
    }

    @Override
    public MemoryObject newObject(String path, boolean overwrite) throws Exception {
        this.mailboxThreadChecker.run();
        String absPath = this.fullPath(path);
        String[] parts = absPath.split("\\.");
        this.fillParents(parts);
        if (this.store.contains(absPath)) {
            MemoryItem existing = this.store.get(absPath);
            if (existing.getType() != ItemType.OBJECT) {
                if (!overwrite) {
                    throw new IllegalArgumentException("Field '" + absPath + "' exists but is not an object.");
                }
                this.store.put(absPath, new MemoryItem());
            }
        } else {
            this.store.put(absPath, new MemoryItem());
        }
        this.memoryUpdates.add(new MemoryUpdate(absPath, null));
        String parent = absPath.contains(SEPARATOR) ? absPath.substring(0, absPath.lastIndexOf(SEPARATOR)) : ROOT_KEY;
        MemoryItem parentItem = this.store.get(parent);
        parentItem.getSubKeys().add(parts[parts.length - 1]);
        this.store.put(parent, parentItem);
        return new MemoryObjectImpl(this.store, absPath, this.memoryUpdates);
    }

    @Override
    public boolean isExist(String path) {
        this.mailboxThreadChecker.run();
        try {
            return this.store.contains(this.fullPath(path));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getFieldNames() throws Exception {
        this.mailboxThreadChecker.run();
        MemoryItem memItem = this.store.get(this.prefix);
        if (memItem != null && memItem.getType() == ItemType.OBJECT) {
            return new ArrayList<String>(memItem.getSubKeys());
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> getFields() throws Exception {
        this.mailboxThreadChecker.run();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String name : this.getFieldNames()) {
            String absPath = this.fullPath(name);
            MemoryItem memItem = this.store.get(absPath);
            if (memItem.getType() == ItemType.OBJECT) {
                result.put(name, "NestedObject");
                continue;
            }
            result.put(name, memItem.getValue());
        }
        return result;
    }

    @Override
    public boolean isNestedObject() throws Exception {
        this.mailboxThreadChecker.run();
        MemoryItem memItem = this.store.get(this.prefix);
        return memItem != null && memItem.getType() == ItemType.OBJECT;
    }

    @Override
    public Object getValue() throws Exception {
        this.mailboxThreadChecker.run();
        MemoryItem memItem = this.store.get(this.prefix);
        if (memItem != null && memItem.getType() == ItemType.VALUE) {
            return memItem.getValue();
        }
        return null;
    }

    private String fullPath(String path) {
        return this.prefix.isEmpty() ? path : this.prefix + SEPARATOR + path;
    }

    private void fillParents(String[] parts) throws Exception {
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < parts.length - 1; ++i) {
            String parent;
            if (i > 0) {
                path.append(SEPARATOR);
            }
            path.append(parts[i]);
            String cur = path.toString();
            String string = parent = i == 0 ? ROOT_KEY : path.substring(0, path.lastIndexOf(SEPARATOR));
            if (!this.store.contains(cur)) {
                this.store.put(cur, new MemoryItem());
            }
            if (!this.store.contains(parent)) {
                this.store.put(parent, new MemoryItem());
            }
            MemoryItem parentNode = this.store.get(parent);
            parentNode.getSubKeys().add(parts[i]);
            this.store.put(parent, parentNode);
        }
    }

    public static final class MemoryItem
    implements Serializable {
        private final ItemType type;
        private final Object value;
        private final Set<String> subKeys;

        MemoryItem(Object value) {
            this.type = ItemType.VALUE;
            this.value = value;
            this.subKeys = Collections.emptySet();
        }

        MemoryItem() {
            this.type = ItemType.OBJECT;
            this.value = null;
            this.subKeys = new HashSet<String>();
        }

        public ItemType getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public Set<String> getSubKeys() {
            return this.subKeys;
        }
    }

    private static enum ItemType {
        OBJECT,
        VALUE;

    }
}

