/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.util.RawCharSequence;
import org.eclipse.jgit.util.RawSubStringPattern;

public abstract class SubStringRevFilter
extends RevFilter {
    private final RawSubStringPattern pattern;

    public static boolean safe(String pattern) {
        int i2 = 0;
        while (i2 < pattern.length()) {
            char c = pattern.charAt(i2);
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    protected SubStringRevFilter(String patternText) {
        this.pattern = new RawSubStringPattern(patternText);
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.pattern.match(this.text(cmit)) >= 0;
    }

    @Override
    public boolean requiresCommitBody() {
        return true;
    }

    protected abstract RawCharSequence text(RevCommit var1);

    @Override
    public RevFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "(\"" + this.pattern.pattern() + "\")";
    }
}

