/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.util.regex.Pattern;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;

public class ChangeIdUtil {
    static final String CHANGE_ID = "Change-Id:";
    private static final Pattern issuePattern = Pattern.compile("^(Bug|Issue)[a-zA-Z0-9-]*:.*$");
    private static final Pattern footerPattern = Pattern.compile("(^[a-zA-Z0-9-]+:(?!//).*$)");
    private static final Pattern changeIdPattern = Pattern.compile("(^Change-Id: *I[a-f0-9]{40}$)");
    private static final Pattern includeInFooterPattern = Pattern.compile("^[ \\[].*$");
    private static final Pattern trailingWhitespace = Pattern.compile("\\s+$");

    static String clean(String msg) {
        return msg.replaceAll("(?i)(?m)^Signed-off-by:.*$\n?", "").replaceAll("(?m)^#.*$\n?", "").replaceAll("(?m)\n\n\n+", "\\\n").replaceAll("\\n*$", "").replaceAll("(?s)\ndiff --git.*", "").trim();
    }

    public static ObjectId computeChangeId(ObjectId treeId, ObjectId firstParentId, PersonIdent author, PersonIdent committer, String message) {
        String cleanMessage = ChangeIdUtil.clean(message);
        if (cleanMessage.length() == 0) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append("tree ");
        b.append(ObjectId.toString(treeId));
        b.append("\n");
        if (firstParentId != null) {
            b.append("parent ");
            b.append(ObjectId.toString(firstParentId));
            b.append("\n");
        }
        b.append("author ");
        b.append(author.toExternalString());
        b.append("\n");
        b.append("committer ");
        b.append(committer.toExternalString());
        b.append("\n\n");
        b.append(cleanMessage);
        Throwable throwable = null;
        Object var8_9 = null;
        try (ObjectInserter.Formatter f = new ObjectInserter.Formatter();){
            return f.idFor(1, Constants.encode(b.toString()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String insertId(String message, ObjectId changeId) {
        return ChangeIdUtil.insertId(message, changeId, false);
    }

    public static String insertId(String message, ObjectId changeId, boolean replaceExisting) {
        int footerFirstLine;
        int indexOfChangeId = ChangeIdUtil.indexOfChangeId(message, "\n");
        if (indexOfChangeId > 0) {
            if (!replaceExisting) {
                return message;
            }
            StringBuilder ret = new StringBuilder(message.substring(0, indexOfChangeId));
            ret.append(CHANGE_ID);
            ret.append(" I");
            ret.append(ObjectId.toString(changeId));
            int indexOfNextLineBreak = message.indexOf(10, indexOfChangeId);
            if (indexOfNextLineBreak > 0) {
                ret.append(message.substring(indexOfNextLineBreak));
            }
            return ret.toString();
        }
        String[] lines = message.split("\n");
        int insertAfter = footerFirstLine = ChangeIdUtil.indexOfFirstFooterLine(lines);
        int i2 = footerFirstLine;
        while (i2 < lines.length) {
            if (!issuePattern.matcher(lines[i2]).matches()) break;
            insertAfter = i2 + 1;
            ++i2;
        }
        StringBuilder ret = new StringBuilder();
        int i3 = 0;
        while (i3 < insertAfter) {
            ret.append(lines[i3]);
            ret.append("\n");
            ++i3;
        }
        if (insertAfter == lines.length && insertAfter == footerFirstLine) {
            ret.append("\n");
        }
        ret.append(CHANGE_ID);
        ret.append(" I");
        ret.append(ObjectId.toString(changeId));
        ret.append("\n");
        while (i3 < lines.length) {
            ret.append(lines[i3]);
            ret.append("\n");
            ++i3;
        }
        return ret.toString();
    }

    public static int indexOfChangeId(String message, String delimiter) {
        String[] lines = message.split(delimiter);
        if (lines.length == 0) {
            return -1;
        }
        int indexOfChangeIdLine = 0;
        boolean inFooter = false;
        int i2 = lines.length - 1;
        while (i2 >= 0) {
            if (inFooter || !ChangeIdUtil.isEmptyLine(lines[i2])) {
                inFooter = true;
                if (changeIdPattern.matcher(ChangeIdUtil.trimRight(lines[i2])).matches()) {
                    indexOfChangeIdLine = i2;
                    break;
                }
                if (ChangeIdUtil.isEmptyLine(lines[i2]) || i2 == 0) {
                    return -1;
                }
            }
            --i2;
        }
        int indexOfChangeIdLineinString = 0;
        int i3 = 0;
        while (i3 < indexOfChangeIdLine) {
            indexOfChangeIdLineinString += lines[i3].length() + delimiter.length();
            ++i3;
        }
        return indexOfChangeIdLineinString + lines[indexOfChangeIdLine].indexOf(CHANGE_ID);
    }

    private static boolean isEmptyLine(String line) {
        return line.trim().length() == 0;
    }

    private static String trimRight(String s) {
        return trailingWhitespace.matcher(s).replaceAll("");
    }

    public static int indexOfFirstFooterLine(String[] lines) {
        int footerFirstLine = lines.length;
        int i2 = lines.length - 1;
        while (i2 > 1) {
            if (footerPattern.matcher(lines[i2]).matches()) {
                footerFirstLine = i2;
            } else {
                if (footerFirstLine != lines.length && lines[i2].length() == 0) break;
                if (footerFirstLine != lines.length && includeInFooterPattern.matcher(lines[i2]).matches()) {
                    footerFirstLine = i2 + 1;
                } else {
                    footerFirstLine = lines.length;
                    break;
                }
            }
            --i2;
        }
        return footerFirstLine;
    }
}

