/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core.io;

import java.util.Collection;
import org.grails.core.io.DefaultResourceLocator;
import org.grails.core.io.ResourceLocator;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;

public class PluginPathAwareFileSystemResourceLoader
extends FileSystemResourceLoader {
    public static final String WEB_APP_DIRECTORY = "web-app";
    ResourceLocator resourceLocator = new DefaultResourceLocator();

    public void setSearchLocations(Collection<String> searchLocations) {
        this.resourceLocator.setSearchLocations(searchLocations);
    }

    @Override
    protected Resource getResourceByPath(String path) {
        Resource res;
        Resource resource = super.getResourceByPath(path);
        if (resource != null && resource.exists()) {
            return resource;
        }
        String resourcePath = path;
        if (resourcePath.startsWith(WEB_APP_DIRECTORY)) {
            resourcePath = resourcePath.substring(WEB_APP_DIRECTORY.length(), resourcePath.length());
        }
        if ((res = this.resourceLocator.findResourceForURI(resourcePath)) != null) {
            return res;
        }
        return new FileSystemContextResource(path);
    }

    private static class FileSystemContextResource
    extends FileSystemResource
    implements ContextResource {
        public FileSystemContextResource(String path) {
            super(path);
        }

        @Override
        public String getPathWithinContext() {
            return this.getPath();
        }
    }
}

