/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.build.dependencies;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.Ordered;
import java.util.Objects;
import org.grails.forge.build.dependencies.Coordinate;
import org.grails.forge.build.dependencies.Dependency;

@Introspected
public class DependencyCoordinate
implements Coordinate,
Ordered {
    private final String groupId;
    private final String artifactId;
    @Nullable
    private final String version;
    private final int order;
    private final boolean pom;

    public DependencyCoordinate(Dependency dependency) {
        this(dependency, false);
    }

    public DependencyCoordinate(Dependency dependency, boolean showVersionProperty) {
        this.groupId = dependency.getGroupId();
        this.artifactId = dependency.getArtifactId();
        this.version = showVersionProperty && dependency.getVersionProperty() != null ? "${" + dependency.getVersionProperty() + "}" : dependency.getVersion();
        this.order = dependency.getOrder();
        this.pom = dependency.isPom();
    }

    public DependencyCoordinate(String groupId, String artifactId, @Nullable String version, int order, boolean pom) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.order = order;
        this.pom = pom;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    @NonNull
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @NonNull
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isPom() {
        return this.pom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyCoordinate that = (DependencyCoordinate)o;
        return Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getArtifactId(), that.getArtifactId()) && this.isPom() == that.isPom();
    }

    public int hashCode() {
        return Objects.hash(this.getGroupId(), this.getArtifactId(), this.isPom());
    }
}

