/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class LongLongArrayColumnIterator
implements Iterator<long[]> {
    private final long[][] array;
    private int columnIndex = 0;
    private int numColumns;

    public LongLongArrayColumnIterator(long[][] array) {
        Objects.requireNonNull(array);
        this.array = array;
        this.numColumns = Integer.MAX_VALUE;
        for (long[] row : array) {
            if (row.length >= this.numColumns) continue;
            this.numColumns = row.length;
        }
        if (this.numColumns == Integer.MAX_VALUE) {
            this.numColumns = 0;
        }
    }

    @Override
    public boolean hasNext() {
        return this.columnIndex < this.numColumns;
    }

    @Override
    public long[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        long[] col = new long[this.array.length];
        for (int r = 0; r < this.array.length; ++r) {
            col[r] = this.array[r][this.columnIndex];
        }
        ++this.columnIndex;
        return col;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported for arrays");
    }
}

