/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.util.CollectionUtils;

public class TableSpoolNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private int requested;
    private int waiting;
    private int rowIdx;
    private final List<RowT> rows;
    private final boolean lazyRead;
    private boolean inLoop;

    public TableSpoolNode(ExecutionContext<RowT> ctx, boolean lazyRead) {
        super(ctx);
        this.lazyRead = lazyRead;
        this.rows = new ArrayList<RowT>();
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.rowIdx = 0;
    }

    @Override
    public void rewind() {
        this.rewindInternal();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0);
        this.requested += rowsCnt;
        if (!(this.waiting != -1 && this.rowIdx >= this.rows.size() || this.inLoop)) {
            this.execute(this::doPush);
        } else if (this.waiting == 0) {
            this.waiting = this.inBufSize;
            this.source().request(this.waiting);
        }
    }

    private void doPush() throws Exception {
        if (!this.lazyRead && this.waiting != -1) {
            return;
        }
        int processed = 0;
        this.inLoop = true;
        try {
            while (this.requested > 0 && this.rowIdx < this.rows.size()) {
                if (processed++ >= this.inBufSize) {
                    this.execute(this::doPush);
                    return;
                }
                this.downstream().push(this.rows.get(this.rowIdx));
                ++this.rowIdx;
                --this.requested;
            }
        }
        finally {
            this.inLoop = false;
        }
        if (this.rowIdx >= this.rows.size() && this.waiting == -1 && this.requested > 0) {
            this.requested = 0;
            this.downstream().end();
        }
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        --this.waiting;
        this.rows.add(row);
        if (this.waiting == 0) {
            this.waiting = this.inBufSize;
            this.source().request(this.waiting);
        }
        if (this.requested > 0 && this.rowIdx < this.rows.size()) {
            this.doPush();
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.waiting = -1;
        this.execute(this::doPush);
    }

    @Override
    protected void dumpDebugInfo0(IgniteStringBuilder buf) {
        buf.app("class=").app(this.getClass().getSimpleName()).app(", requested=").app(this.requested).app(", waiting=").app(this.waiting);
    }
}

