/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine;

import com.google.protobuf.Struct;
import java.util.Map;
import org.apache.bifromq.basehookloader.BaseHookLoader;
import org.apache.bifromq.basekv.localengine.ICPableKVSpace;
import org.apache.bifromq.basekv.localengine.IKVEngine;
import org.apache.bifromq.basekv.localengine.IWALableKVSpace;
import org.apache.bifromq.basekv.localengine.spi.IKVEngineProvider;

public class KVEngineFactory {
    public static IKVEngine<? extends ICPableKVSpace> createCPable(String overrideIdentity, String type, Struct conf) {
        Map providers = BaseHookLoader.load(IKVEngineProvider.class);
        for (IKVEngineProvider provider : providers.values()) {
            if (!provider.type().equalsIgnoreCase(type)) continue;
            return provider.createCPable(overrideIdentity, conf);
        }
        throw new UnsupportedOperationException("No CP-able KVEngineProvider found for type: " + type);
    }

    public static IKVEngine<? extends IWALableKVSpace> createWALable(String overrideIdentity, String type, Struct conf) {
        Map providers = BaseHookLoader.load(IKVEngineProvider.class);
        for (IKVEngineProvider provider : providers.values()) {
            if (!provider.type().equalsIgnoreCase(type)) continue;
            return provider.createWALable(overrideIdentity, conf);
        }
        throw new UnsupportedOperationException("No WAL-able KVEngineProvider found for type: " + type);
    }
}

