/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server;

import com.google.common.util.concurrent.MoreExecutors;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.inbox.RPCBluePrint;
import org.apache.bifromq.inbox.server.IInboxServer;
import org.apache.bifromq.inbox.server.InboxServerBuilder;
import org.apache.bifromq.inbox.server.InboxService;
import org.apache.bifromq.inbox.server.TenantGCRunner;
import org.apache.bifromq.inbox.server.scheduler.InboxAttachScheduler;
import org.apache.bifromq.inbox.server.scheduler.InboxCheckSubScheduler;
import org.apache.bifromq.inbox.server.scheduler.InboxCommitScheduler;
import org.apache.bifromq.inbox.server.scheduler.InboxDeleteScheduler;
import org.apache.bifromq.inbox.server.scheduler.InboxDetachScheduler;
import org.apache.bifromq.inbox.server.scheduler.InboxExistScheduler;
import org.apache.bifromq.inbox.server.scheduler.InboxFetchScheduler;
import org.apache.bifromq.inbox.server.scheduler.InboxFetchStateScheduler;
import org.apache.bifromq.inbox.server.scheduler.InboxInsertScheduler;
import org.apache.bifromq.inbox.server.scheduler.InboxSendLWTScheduler;
import org.apache.bifromq.inbox.server.scheduler.InboxSubScheduler;
import org.apache.bifromq.inbox.server.scheduler.InboxUnSubScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InboxServer
implements IInboxServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxServer.class);
    private final InboxService inboxService;
    private final ExecutorService rpcExecutor;

    InboxServer(InboxServerBuilder builder) {
        this.inboxService = InboxService.builder().inboxClient(builder.inboxClient).distClient(builder.distClient).fetchStateScheduler(new InboxFetchStateScheduler(builder.inboxStoreClient)).existScheduler(new InboxExistScheduler(builder.inboxStoreClient)).sendLWTScheduler(new InboxSendLWTScheduler(builder.inboxStoreClient)).checkSubScheduler(new InboxCheckSubScheduler(builder.inboxStoreClient)).fetchScheduler(new InboxFetchScheduler(builder.inboxStoreClient)).insertScheduler(new InboxInsertScheduler(builder.inboxStoreClient)).commitScheduler(new InboxCommitScheduler(builder.inboxStoreClient)).attachScheduler(new InboxAttachScheduler(builder.inboxStoreClient)).detachScheduler(new InboxDetachScheduler(builder.inboxStoreClient)).deleteScheduler(new InboxDeleteScheduler(builder.inboxStoreClient)).subScheduler(new InboxSubScheduler(builder.inboxStoreClient)).unsubScheduler(new InboxUnSubScheduler(builder.inboxStoreClient)).tenantGCRunner(new TenantGCRunner(builder.inboxStoreClient)).build();
        this.rpcExecutor = builder.workerThreads == 0 ? MoreExecutors.newDirectExecutorService() : ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(builder.workerThreads, builder.workerThreads, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("inbox-server-executor")), (String)"inbox-server-executor", (Tag[])new Tag[0]);
        builder.rpcServerBuilder.bindService(this.inboxService.bindService(), RPCBluePrint.INSTANCE, builder.attributes, builder.defaultGroupTags, (Executor)this.rpcExecutor);
        this.start();
    }

    private void start() {
        log.debug("Starting inbox service");
        this.inboxService.start();
    }

    @Override
    public void close() {
        log.info("Stopping InboxService");
        this.inboxService.stop();
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.rpcExecutor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        log.info("InboxService stopped");
    }
}

