/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.store.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bifromq.retain.store.index.IRetainTopicIndex;
import org.apache.bifromq.retain.store.index.RetainedMsgInfo;
import org.apache.bifromq.util.TopicUtil;
import org.apache.bifromq.util.index.Branch;
import org.apache.bifromq.util.index.TopicLevelTrie;

public class RetainTopicIndex
extends TopicLevelTrie<RetainedMsgInfo>
implements IRetainTopicIndex {
    private static final TopicLevelTrie.BranchSelector RetainMatcher = new TopicLevelTrie.BranchSelector(){

        public <T> Map<Branch<T>, TopicLevelTrie.BranchSelector.Action> selectBranch(Map<String, Branch<T>> branches, List<String> topicLevels, int currentLevel) {
            if (topicLevels.isEmpty()) {
                HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action> result = new HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action>();
                for (Map.Entry<String, Branch<T>> entry : branches.entrySet()) {
                    Branch<T> branch = entry.getValue();
                    result.put(branch, TopicLevelTrie.BranchSelector.Action.MATCH_AND_CONTINUE);
                }
                return result;
            }
            if (currentLevel < topicLevels.size() - 1) {
                String topicLevelToMatch;
                boolean matchParent = currentLevel + 1 == topicLevels.size() - 1 && topicLevels.get(currentLevel + 1).equals("#");
                switch (topicLevelToMatch = topicLevels.get(currentLevel)) {
                    case "+": {
                        HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action> result = new HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action>();
                        for (Map.Entry<String, Branch<T>> entry : branches.entrySet()) {
                            Branch<T> branch = entry.getValue();
                            if (currentLevel == 1 && entry.getKey().startsWith("$")) continue;
                            result.put(branch, matchParent ? TopicLevelTrie.BranchSelector.Action.MATCH_AND_CONTINUE : TopicLevelTrie.BranchSelector.Action.CONTINUE);
                        }
                        return result;
                    }
                }
                assert (!topicLevelToMatch.equals("#")) : "MULTI_WILDCARD should be the last level";
                if (branches.containsKey(topicLevelToMatch)) {
                    return Map.of(branches.get(topicLevelToMatch), matchParent ? TopicLevelTrie.BranchSelector.Action.MATCH_AND_CONTINUE : TopicLevelTrie.BranchSelector.Action.CONTINUE);
                }
                return Collections.emptyMap();
            }
            if (currentLevel == topicLevels.size() - 1) {
                String topicLevelToMatch;
                switch (topicLevelToMatch = topicLevels.get(currentLevel)) {
                    case "+": {
                        HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action> result = new HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action>();
                        for (Map.Entry<String, Branch<T>> entry : branches.entrySet()) {
                            Branch<T> branch = entry.getValue();
                            if (currentLevel == 1 && entry.getKey().startsWith("$")) continue;
                            result.put(branch, TopicLevelTrie.BranchSelector.Action.MATCH_AND_STOP);
                        }
                        return result;
                    }
                    case "#": {
                        HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action> result = new HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action>();
                        for (Map.Entry<String, Branch<T>> entry : branches.entrySet()) {
                            Branch<T> branch = entry.getValue();
                            if (currentLevel == 1 && entry.getKey().startsWith("$")) continue;
                            result.put(branch, TopicLevelTrie.BranchSelector.Action.MATCH_AND_CONTINUE);
                        }
                        return result;
                    }
                }
                if (branches.containsKey(topicLevelToMatch)) {
                    return Map.of(branches.get(topicLevelToMatch), TopicLevelTrie.BranchSelector.Action.MATCH_AND_STOP);
                }
                return Collections.emptyMap();
            }
            HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action> result = new HashMap<Branch<T>, TopicLevelTrie.BranchSelector.Action>();
            for (Map.Entry<String, Branch<T>> entry : branches.entrySet()) {
                Branch<T> branch = entry.getValue();
                result.put(branch, TopicLevelTrie.BranchSelector.Action.MATCH_AND_CONTINUE);
            }
            return result;
        }
    };

    @Override
    public void add(String tenantId, String topic, long timestamp, int expirySeconds) {
        this.add(TopicUtil.parse((String)tenantId, (String)topic, (boolean)false), new RetainedMsgInfo(tenantId, topic, timestamp, expirySeconds));
    }

    @Override
    public void remove(String tenantId, String topic) {
        this.remove(TopicUtil.parse((String)tenantId, (String)topic, (boolean)false), new RetainedMsgInfo(tenantId, topic, 0L, 0));
    }

    @Override
    public Set<RetainedMsgInfo> match(String tenantId, String topicFilter) {
        return this.lookup(TopicUtil.parse((String)tenantId, (String)topicFilter, (boolean)false), RetainMatcher);
    }

    @Override
    public Set<RetainedMsgInfo> findAll() {
        return this.lookup(Collections.emptyList(), RetainMatcher);
    }
}

