/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.credentials.connection;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.polaris.core.credentials.connection.ConnectionCredentials;
import org.immutables.value.Generated;

@Generated(from="ConnectionCredentials", generator="Immutables")
public final class ImmutableConnectionCredentials
implements ConnectionCredentials {
    private final ImmutableMap<String, String> credentials;
    private final Instant expiresAt;
    private transient int hashCode;

    private ImmutableConnectionCredentials(ImmutableMap<String, String> credentials, Instant expiresAt) {
        this.credentials = credentials;
        this.expiresAt = expiresAt;
    }

    public ImmutableMap<String, String> credentials() {
        return this.credentials;
    }

    @Override
    public Optional<Instant> expiresAt() {
        return Optional.ofNullable(this.expiresAt);
    }

    public final ImmutableConnectionCredentials withCredentials(Map<String, ? extends String> entries) {
        if (this.credentials == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableConnectionCredentials((ImmutableMap<String, String>)newValue, this.expiresAt);
    }

    public final ImmutableConnectionCredentials withExpiresAt(Instant value) {
        Instant newValue = Objects.requireNonNull(value, "expiresAt");
        if (this.expiresAt == newValue) {
            return this;
        }
        return new ImmutableConnectionCredentials(this.credentials, newValue);
    }

    public final ImmutableConnectionCredentials withExpiresAt(Optional<? extends Instant> optional) {
        Instant value = optional.orElse(null);
        if (this.expiresAt == value) {
            return this;
        }
        return new ImmutableConnectionCredentials(this.credentials, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConnectionCredentials && this.equalsByValue((ImmutableConnectionCredentials)another);
    }

    private boolean equalsByValue(ImmutableConnectionCredentials another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.credentials.equals(another.credentials) && Objects.equals(this.expiresAt, another.expiresAt);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.credentials.hashCode();
        h += (h << 5) + Objects.hashCode(this.expiresAt);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConnectionCredentials").omitNullValues().add("credentials", this.credentials).add("expiresAt", (Object)this.expiresAt).toString();
    }

    public static ImmutableConnectionCredentials copyOf(ConnectionCredentials instance) {
        if (instance instanceof ImmutableConnectionCredentials) {
            return (ImmutableConnectionCredentials)instance;
        }
        return ImmutableConnectionCredentials.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableConnectionCredentials.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConnectionCredentials", generator="Immutables")
    public static final class Builder
    implements ConnectionCredentials.Builder {
        private ImmutableMap.Builder<String, String> credentials = ImmutableMap.builder();
        private Instant expiresAt;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ConnectionCredentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllCredentials(instance.credentials());
            Optional<Instant> expiresAtOptional = instance.expiresAt();
            if (expiresAtOptional.isPresent()) {
                this.expiresAt(expiresAtOptional);
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putCredential(String key, String value) {
            this.credentials.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCredential(Map.Entry<String, ? extends String> entry) {
            this.credentials.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder credentials(Map<String, ? extends String> entries) {
            this.credentials = ImmutableMap.builder();
            return this.putAllCredentials(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCredentials(Map<String, ? extends String> entries) {
            this.credentials.putAll(entries);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = Objects.requireNonNull(expiresAt, "expiresAt");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiresAt(Optional<? extends Instant> expiresAt) {
            this.expiresAt = expiresAt.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.credentials = ImmutableMap.builder();
            this.expiresAt = null;
            return this;
        }

        @Override
        public ImmutableConnectionCredentials build() {
            return new ImmutableConnectionCredentials((ImmutableMap<String, String>)this.credentials.build(), this.expiresAt);
        }
    }
}

