/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.runtime;

import io.quarkiverse.amazon.common.runtime.FileStoreTlsManagersProviderConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.TlsTrustManagersProvider;

public class FileStoreTlsTrustManagersProvider
implements TlsTrustManagersProvider {
    private final Path path;
    private final String type;
    private final char[] password;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileStoreTlsTrustManagersProvider.class);

    public FileStoreTlsTrustManagersProvider(FileStoreTlsManagersProviderConfig fileStore) {
        this.path = fileStore.path().get();
        this.type = fileStore.type().get();
        this.password = fileStore.password().map(String::toCharArray).orElse(null);
    }

    public TrustManager[] trustManagers() {
        TrustManager[] trustManagerArray;
        block8: {
            InputStream storeInputStream = Files.newInputStream(this.path, new OpenOption[0]);
            try {
                KeyStore keyStore = KeyStore.getInstance(this.type);
                keyStore.load(storeInputStream, this.password);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(keyStore);
                trustManagerArray = tmf.getTrustManagers();
                if (storeInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (storeInputStream != null) {
                        try {
                            storeInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    LOGGER.error("Failed to load truststore", (Throwable)e);
                    return null;
                }
            }
            storeInputStream.close();
        }
        return trustManagerArray;
    }
}

