/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.model.ModelInformation;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class UpdateModelInfoPlan
extends ConfigPhysicalPlan {
    private String modelName;
    private ModelInformation modelInformation;
    private List<Integer> nodeIds;

    public UpdateModelInfoPlan() {
        super(ConfigPhysicalPlanType.UpdateModelInfo);
    }

    public UpdateModelInfoPlan(String modelName, ModelInformation modelInformation) {
        super(ConfigPhysicalPlanType.UpdateModelInfo);
        this.modelName = modelName;
        this.modelInformation = modelInformation;
        this.nodeIds = Collections.emptyList();
    }

    public UpdateModelInfoPlan(String modelName, ModelInformation modelInformation, List<Integer> nodeIds) {
        super(ConfigPhysicalPlanType.UpdateModelInfo);
        this.modelName = modelName;
        this.modelInformation = modelInformation;
        this.nodeIds = nodeIds;
    }

    public String getModelName() {
        return this.modelName;
    }

    public ModelInformation getModelInformation() {
        return this.modelInformation;
    }

    public List<Integer> getNodeIds() {
        return this.nodeIds;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.modelName, (OutputStream)stream);
        this.modelInformation.serialize(stream);
        ReadWriteIOUtils.write((int)this.nodeIds.size(), (OutputStream)stream);
        for (Integer nodeId : this.nodeIds) {
            ReadWriteIOUtils.write((int)nodeId, (OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.modelName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.modelInformation = ModelInformation.deserialize((ByteBuffer)buffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.nodeIds = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            this.nodeIds.add(ReadWriteIOUtils.readInt((ByteBuffer)buffer));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UpdateModelInfoPlan that = (UpdateModelInfoPlan)o;
        return this.modelName.equals(that.modelName) && this.modelInformation.equals((Object)that.modelInformation) && this.nodeIds.equals(that.nodeIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modelName, this.modelInformation, this.nodeIds);
    }
}

