/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.ServletConfig;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.iotdb.db.protocol.rest.v2.NotFoundException;
import org.apache.iotdb.db.protocol.rest.v2.RestApiService;
import org.apache.iotdb.db.protocol.rest.v2.factories.RestApiServiceFactory;
import org.apache.iotdb.db.protocol.rest.v2.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.v2.model.InsertRecordsRequest;
import org.apache.iotdb.db.protocol.rest.v2.model.InsertTabletRequest;
import org.apache.iotdb.db.protocol.rest.v2.model.PrefixPathList;
import org.apache.iotdb.db.protocol.rest.v2.model.QueryDataSet;
import org.apache.iotdb.db.protocol.rest.v2.model.SQL;

@Path(value="/rest/v2")
@Api(description="the rest API")
public class RestApi {
    private final RestApiService delegate;

    public RestApi(@Context ServletConfig servletContext) {
        String implClass;
        RestApiService delegate = null;
        if (servletContext != null && (implClass = servletContext.getInitParameter("RestApi.implementation")) != null && !"".equals(implClass.trim())) {
            try {
                delegate = (RestApiService)Class.forName(implClass).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (delegate == null) {
            delegate = RestApiServiceFactory.getRestApi();
        }
        this.delegate = delegate;
    }

    @POST
    @Path(value="/fastLastQuery")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="executeFastLastQueryStatement", notes="executeFastLastQueryStatement", response=QueryDataSet.class, authorizations={@Authorization(value="basic")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="QueryDataSet", response=QueryDataSet.class)})
    public Response executeFastLastQueryStatement(@ApiParam(value="") @Valid PrefixPathList prefixPathList, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.executeFastLastQueryStatement(prefixPathList, securityContext);
    }

    @POST
    @Path(value="/nonQuery")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="executeNonQueryStatement", notes="executeNonQueryStatement", response=ExecutionStatus.class, authorizations={@Authorization(value="basic")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="ExecutionStatus", response=ExecutionStatus.class)})
    public Response executeNonQueryStatement(@ApiParam(value="") @Valid SQL SQL2, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.executeNonQueryStatement(SQL2, securityContext);
    }

    @POST
    @Path(value="/query")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="executeQueryStatement", notes="executeQueryStatement", response=QueryDataSet.class, authorizations={@Authorization(value="basic")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="QueryDataSet", response=QueryDataSet.class)})
    public Response executeQueryStatement(@ApiParam(value="") @Valid SQL SQL2, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.executeQueryStatement(SQL2, securityContext);
    }

    @POST
    @Path(value="/insertRecords")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="insertRecords", notes="insertRecords", response=ExecutionStatus.class, authorizations={@Authorization(value="basic")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="ExecutionStatus", response=ExecutionStatus.class)})
    public Response insertRecords(@ApiParam(value="") @Valid InsertRecordsRequest insertRecordsRequest, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.insertRecords(insertRecordsRequest, securityContext);
    }

    @POST
    @Path(value="/insertTablet")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="insertTablet", notes="insertTablet", response=ExecutionStatus.class, authorizations={@Authorization(value="basic")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="ExecutionStatus", response=ExecutionStatus.class)})
    public Response insertTablet(@ApiParam(value="") @Valid InsertTabletRequest insertTabletRequest, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.insertTablet(insertTabletRequest, securityContext);
    }
}

