/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public abstract class Node {
    @Nullable
    private final NodeLocation location;

    protected Node(@Nullable NodeLocation location) {
        this.location = location;
    }

    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitNode(this, context);
    }

    public Optional<NodeLocation> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public abstract List<? extends Node> getChildren();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public boolean shallowEquals(Node other) {
        throw new UnsupportedOperationException("not yet implemented: " + this.getClass().getName());
    }

    public static boolean sameClass(Node left, Node right) {
        if (left == right) {
            return true;
        }
        return left.getClass() == right.getClass();
    }
}

