/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SortOrder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GroupNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionProcessorNode;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class ImplementTableFunctionSource
implements Rule<TableFunctionNode> {
    private static final Pattern<TableFunctionNode> PATTERN = Patterns.tableFunction();

    @Override
    public Pattern<TableFunctionNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableFunctionNode node, Captures captures, Rule.Context context) {
        if (node.getChildren().isEmpty()) {
            return Rule.Result.ofPlanNode(new TableFunctionProcessorNode(node.getPlanNodeId(), node.getName(), node.getProperOutputs(), Optional.empty(), Optional.empty(), (List<Symbol>)ImmutableList.of(), Optional.empty(), false, node.getTableFunctionHandle(), false));
        }
        if (node.getChildren().size() == 1) {
            TableFunctionNode.TableArgumentProperties sourceProperties = (TableFunctionNode.TableArgumentProperties)Iterables.getOnlyElement(node.getTableArgumentProperties());
            AtomicReference<PlanNode> child = new AtomicReference<PlanNode>((PlanNode)Iterables.getOnlyElement(node.getChildren()));
            sourceProperties.getDataOrganizationSpecification().ifPresent(dataOrganizationSpecification -> {
                ArrayList<Symbol> sortSymbols = new ArrayList<Symbol>();
                HashMap<Symbol, SortOrder> sortOrderings = new HashMap<Symbol, SortOrder>();
                for (Symbol symbol : dataOrganizationSpecification.getPartitionBy()) {
                    sortSymbols.add(symbol);
                    sortOrderings.put(symbol, SortOrder.ASC_NULLS_LAST);
                }
                int sortKeyOffset = sortSymbols.size();
                dataOrganizationSpecification.getOrderingScheme().ifPresent(orderingScheme -> {
                    for (Symbol symbol : orderingScheme.getOrderBy()) {
                        if (sortOrderings.containsKey(symbol)) continue;
                        sortSymbols.add(symbol);
                        sortOrderings.put(symbol, orderingScheme.getOrdering(symbol));
                    }
                });
                child.set(new GroupNode(context.getIdAllocator().genPlanNodeId(), (PlanNode)child.get(), new OrderingScheme(sortSymbols, sortOrderings), sortKeyOffset));
            });
            return Rule.Result.ofPlanNode(new TableFunctionProcessorNode(node.getPlanNodeId(), node.getName(), node.getProperOutputs(), Optional.of(child.get()), Optional.ofNullable(sourceProperties.getPassThroughSpecification()), sourceProperties.getRequiredColumns(), sourceProperties.getDataOrganizationSpecification(), sourceProperties.isRowSemantics(), node.getTableFunctionHandle(), sourceProperties.isRequireRecordSnapshot()));
        }
        throw new IllegalArgumentException("table function does not support multiple source now.");
    }
}

