/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dmatch;

import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;

public class UDAFDtw
implements UDTF {
    private double[][] dp;
    private int m;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(2).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validateInputSeriesDataType(1, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new SlidingSizeWindowAccessStrategy(Integer.MAX_VALUE)).setOutputDataType(Type.DOUBLE);
    }

    @Override
    public void transform(RowWindow rowWindow, PointCollector collector) throws Exception {
        int i;
        DoubleArrayList a = new DoubleArrayList();
        DoubleArrayList b = new DoubleArrayList();
        int n = rowWindow.windowSize();
        for (i = 0; i < n; ++i) {
            Row row = rowWindow.getRow(i);
            if (row.isNull(0) || row.isNull(1)) continue;
            a.add(Util.getValueAsDouble(row, 0));
            b.add(Util.getValueAsDouble(row, 1));
        }
        this.m = a.size();
        this.dp = new double[this.m + 1][this.m + 1];
        for (i = 1; i <= this.m; ++i) {
            this.dp[i][0] = Double.MAX_VALUE;
            this.dp[0][i] = Double.MAX_VALUE;
        }
        this.dp[0][0] = 0.0;
        for (i = 1; i <= this.m; ++i) {
            for (int j = 1; j <= this.m; ++j) {
                this.dp[i][j] = Math.abs(a.get(i - 1) - b.get(j - 1)) + Math.min(Math.min(this.dp[i][j - 1], this.dp[i - 1][j]), this.dp[i - 1][j - 1]);
            }
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        collector.putDouble(0L, this.dp[this.m][this.m]);
    }
}

