/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.identity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.identity.CustomIdentityDAO;
import org.apache.james.jmap.api.identity.IdentityCreationRequest;
import org.apache.james.jmap.api.identity.IdentityNotFoundException;
import org.apache.james.jmap.api.identity.IdentityUpdate;
import org.apache.james.jmap.api.model.EmailAddress;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.IdentityId;
import org.apache.james.jmap.postgres.identity.PostgresCustomIdentityDataDefinition;
import org.jooq.Field;
import org.jooq.JSON;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;
import scala.runtime.BoxedUnit;

public class PostgresCustomIdentityDAO
implements CustomIdentityDAO {
    private final PostgresExecutor.Factory executorFactory;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public PostgresCustomIdentityDAO(PostgresExecutor.Factory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public Publisher<Identity> save(Username user, IdentityCreationRequest creationRequest) {
        return this.save(user, IdentityId.generate(), creationRequest);
    }

    public Publisher<Identity> save(Username user, IdentityId identityId, IdentityCreationRequest creationRequest) {
        Identity identity = creationRequest.asIdentity(identityId);
        return this.upsertReturnMono(user, identity);
    }

    public Publisher<Identity> list(Username user) {
        return this.executorFactory.create(user.getDomainPart()).executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.TABLE_NAME).where(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.USERNAME.eq((Object)user.asString())))).map((Function)Throwing.function(this::readRecord));
    }

    public SMono<Identity> findByIdentityId(Username user, IdentityId identityId) {
        return SMono.fromPublisher((Publisher)this.executorFactory.create(user.getDomainPart()).executeRow(dslContext -> Mono.from((Publisher)dslContext.selectFrom(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.TABLE_NAME).where(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.USERNAME.eq((Object)user.asString())).and(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.ID.eq((Object)identityId.id())))).map((Function)Throwing.function(this::readRecord)));
    }

    public Publisher<BoxedUnit> update(Username user, IdentityId identityId, IdentityUpdate identityUpdate) {
        return Mono.from(this.findByIdentityId(user, identityId)).switchIfEmpty(Mono.error((Throwable)new IdentityNotFoundException(identityId))).map(arg_0 -> ((IdentityUpdate)identityUpdate).update(arg_0)).flatMap(identity -> this.upsertReturnMono(user, (Identity)identity)).thenReturn((Object)BoxedUnit.UNIT);
    }

    public SMono<BoxedUnit> upsert(Username user, Identity patch) {
        return SMono.fromPublisher((Publisher)this.upsertReturnMono(user, patch).thenReturn((Object)BoxedUnit.UNIT));
    }

    private Mono<Identity> upsertReturnMono(Username user, Identity identity) {
        return this.executorFactory.create(user.getDomainPart()).executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.TABLE_NAME).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.USERNAME, (Object)user.asString()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.ID, (Object)identity.id().id()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.NAME, (Object)identity.name()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.EMAIL, (Object)identity.email().asString()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.TEXT_SIGNATURE, (Object)identity.textSignature()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.HTML_SIGNATURE, (Object)identity.htmlSignature()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.MAY_DELETE, (Object)identity.mayDelete()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.SORT_ORDER, (Object)identity.sortOrder()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.REPLY_TO, (Object)this.convertToJooqJson((Option<List<EmailAddress>>)identity.replyTo())).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.BCC, (Object)this.convertToJooqJson((Option<List<EmailAddress>>)identity.bcc())).onConflict(new Field[]{PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.USERNAME, PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.ID}).doUpdate().set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.NAME, (Object)identity.name()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.EMAIL, (Object)identity.email().asString()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.TEXT_SIGNATURE, (Object)identity.textSignature()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.HTML_SIGNATURE, (Object)identity.htmlSignature()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.MAY_DELETE, (Object)identity.mayDelete()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.SORT_ORDER, (Object)identity.sortOrder()).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.REPLY_TO, (Object)this.convertToJooqJson((Option<List<EmailAddress>>)identity.replyTo())).set(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.BCC, (Object)this.convertToJooqJson((Option<List<EmailAddress>>)identity.bcc())))).thenReturn((Object)identity);
    }

    public Publisher<BoxedUnit> delete(Username username, Set<IdentityId> ids) {
        if (ids.isEmpty()) {
            return Mono.empty();
        }
        return this.executorFactory.create(username.getDomainPart()).executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.TABLE_NAME).where(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.USERNAME.eq((Object)username.asString())).and(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.ID.in((Collection)CollectionConverters.asJavaCollection((Iterable)ids).stream().map(IdentityId::id).collect(ImmutableList.toImmutableList()))))).thenReturn((Object)BoxedUnit.UNIT);
    }

    public Publisher<BoxedUnit> delete(Username username) {
        return this.executorFactory.create(username.getDomainPart()).executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.TABLE_NAME).where(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.USERNAME.eq((Object)username.asString())))).thenReturn((Object)BoxedUnit.UNIT);
    }

    private Identity readRecord(Record record) throws Exception {
        return new Identity(new IdentityId((UUID)record.get(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.ID)), ((Integer)record.get(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.SORT_ORDER)).intValue(), (String)record.get(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.NAME), new MailAddress((String)record.get(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.EMAIL)), this.convertToScala((JSON)record.get(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.REPLY_TO)), this.convertToScala((JSON)record.get(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.BCC)), (String)record.get(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.TEXT_SIGNATURE), (String)record.get(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.HTML_SIGNATURE), ((Boolean)record.get(PostgresCustomIdentityDataDefinition.PostgresCustomIdentityTable.MAY_DELETE)).booleanValue());
    }

    private Option<List<EmailAddress>> convertToScala(JSON json) {
        return OptionConverters.toScala(Optional.of(CollectionConverters.asScala(this.convertToObject(json.data()).stream().map(Throwing.function(email -> EmailAddress.from(Optional.ofNullable(email.getName()), (MailAddress)new MailAddress(email.getEmail())))).iterator()).toList()));
    }

    private JSON convertToJooqJson(Option<List<EmailAddress>> maybeEmailAddresses) {
        return this.convertToJooqJson((java.util.List)OptionConverters.toJava(maybeEmailAddresses).map(emailAddresses -> (ImmutableList)CollectionConverters.asJavaCollection((Iterable)emailAddresses).stream().map(emailAddress -> new Email(emailAddress.nameAsString(), emailAddress.email().asString())).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of()));
    }

    private JSON convertToJooqJson(java.util.List<Email> list) {
        try {
            return JSON.json((String)this.objectMapper.writeValueAsString(list));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private java.util.List<Email> convertToObject(String json) {
        try {
            return (java.util.List)this.objectMapper.readValue(json, (TypeReference)new TypeReference<java.util.List<Email>>(this){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static class Email {
        private final String name;
        private final String email;

        @JsonCreator
        public Email(@JsonProperty(value="name") String name, @JsonProperty(value="email") String email) {
            this.name = name;
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }
    }
}

