/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import java.util.Objects;
import java.util.StringJoiner;
import org.apache.jena.rfc3986.AlgIRI;
import org.apache.jena.rfc3986.AlgResolveIRI;
import org.apache.jena.rfc3986.IRI;
import org.apache.jena.rfc3986.IRI3986;

public class AlgRelativizeIRI {
    public static IRI3986 relativeScheme(IRI base, IRI target) {
        if (!AlgRelativizeIRI.validBase(base)) {
            return null;
        }
        if (!Objects.equals(base.scheme(), target.scheme())) {
            return null;
        }
        return IRI3986.build(null, target.authority(), target.path(), target.query(), target.fragment());
    }

    public static IRI3986 relativeResource(IRI base, IRI target) {
        if (!AlgRelativizeIRI.validBase(base)) {
            return null;
        }
        if (!Objects.equals(base.scheme(), target.scheme())) {
            return null;
        }
        if (!Objects.equals(base.authority(), target.authority())) {
            return null;
        }
        return IRI3986.build(null, null, target.path(), target.query(), target.fragment());
    }

    public static IRI3986 relativeSameDocument(IRI base, IRI target) {
        if (!AlgRelativizeIRI.validBase(base)) {
            return null;
        }
        if (!Objects.equals(base.scheme(), target.scheme())) {
            return null;
        }
        if (!Objects.equals(base.authority(), target.authority())) {
            return null;
        }
        if (Objects.equals(base.path(), target.path()) && !target.hasFragment() && !target.hasQuery()) {
            return IRI3986.build(null, null, "", null, null);
        }
        if (!Objects.equals(base.path(), target.path())) {
            return null;
        }
        if (!Objects.equals(base.query(), target.query())) {
            return null;
        }
        if (!target.hasFragment()) {
            return null;
        }
        return IRI3986.build(null, null, null, null, target.fragment());
    }

    public static IRI3986 relativePath(IRI base, IRI target) {
        String targetPath;
        AlgRelativizeIRI.validBase(base);
        if (!Objects.equals(target.scheme(), base.scheme())) {
            return null;
        }
        if (!Objects.equals(target.authority(), base.authority())) {
            return null;
        }
        String basePath = base.path();
        if (basePath.equals(targetPath = target.path())) {
            if (target.hasQuery()) {
                String x = targetPath.isEmpty() ? "." : "";
                return IRI3986.build(null, null, x, target.query(), target.fragment());
            }
            String pathRel = targetPath.endsWith("/") ? "." : "";
            return IRI3986.build(null, null, pathRel, null, target.fragment());
        }
        String relPath = AlgRelativizeIRI.relativeChildPath(basePath, targetPath);
        if (relPath == null) {
            return null;
        }
        if (relPath.equals(".") && target.hasQuery()) {
            relPath = "";
        }
        return IRI3986.build(null, null, relPath, target.query(), target.fragment());
    }

    private static String lastSegment(String path) {
        int idx = path.lastIndexOf(47);
        if (idx < 0) {
            return path;
        }
        String seg = path.substring(idx + 1);
        return seg;
    }

    private static String relativeChildPath(String basePath, String targetPath) {
        String basePrefix = AlgRelativizeIRI.pathPrefix(basePath);
        boolean targetPathEndInSlash = targetPath.endsWith("/");
        if (!targetPath.startsWith(basePrefix)) {
            return null;
        }
        String relPath = targetPath.substring(basePrefix.length());
        if (targetPathEndInSlash && relPath.isEmpty()) {
            return ".";
        }
        relPath = AlgResolveIRI.safeInitalSegment(relPath);
        return relPath;
    }

    public static IRI3986 relativeParentPath(IRI base, IRI target) {
        if (!Objects.equals(target.scheme(), base.scheme())) {
            return null;
        }
        if (!Objects.equals(target.authority(), base.authority())) {
            return null;
        }
        String relPath = AlgRelativizeIRI.relativeParentPath(base.path(), target.path());
        if (relPath == null) {
            return null;
        }
        return IRI3986.build(null, null, relPath, target.query(), target.fragment());
    }

    private static String relativeParentPath(String basePath, String targetPath) {
        int j;
        String basePrefix = AlgRelativizeIRI.pathPrefix(basePath);
        boolean targetPathEndsInSlash = targetPath.endsWith("/");
        String[] baseSegs = basePrefix.split("/");
        String[] targetSegs = targetPath.split("/");
        int n = Math.min(baseSegs.length, targetSegs.length);
        for (j = 0; j < n && Objects.equals(baseSegs[j], targetSegs[j]); ++j) {
        }
        if (j == baseSegs.length && j <= targetSegs.length && j > 0) {
            String x = "../" + AlgRelativizeIRI.slice(targetSegs, j - 1, "/");
            if (targetPathEndsInSlash) {
                x = x + "/";
            }
            return x;
        }
        if (j + 1 == baseSegs.length) {
            if (j == targetSegs.length) {
                if (targetPathEndsInSlash) {
                    return "..";
                }
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("..");
            for (int k = j; k < targetSegs.length; ++k) {
                sb.append("/");
                sb.append(targetSegs[k]);
            }
            if (targetPathEndsInSlash) {
                sb.append("/");
            }
            return sb.toString();
        }
        return null;
    }

    private static String slice(String[] segs, int start, String sep) {
        StringJoiner sj = new StringJoiner(sep);
        for (int i = start; i < segs.length; ++i) {
            sj.add(segs[i]);
        }
        return sj.toString();
    }

    private static String pathPrefix(String basePath) {
        Objects.requireNonNull(basePath);
        int idx = basePath.lastIndexOf(47);
        if (idx < 0) {
            return null;
        }
        if (idx == 0) {
            return "/";
        }
        String basePrefix = basePath.substring(0, idx + 1);
        return basePrefix;
    }

    static boolean validBase(IRI base) {
        return AlgIRI.validBase(base);
    }
}

