/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.stats;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;

public class ThrownStats
implements Cloneable {
    private final long guid;
    private final long hash;
    private final Class<?> thrownClass;
    private final String firstMessage;
    private final List<String> stackTrace;
    private final Optional<ThrownStats> causedBy;
    private final AtomicInteger count;
    private final AtomicLong firstOccurrence;
    private final AtomicLong lastOccurrence;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    private ThrownStats(ThrownStats x) {
        this.guid = x.guid;
        this.thrownClass = x.thrownClass;
        this.firstMessage = x.firstMessage;
        this.stackTrace = CollectionUtils.u(CollectionUtils.copyOf(x.stackTrace));
        this.causedBy = Utils.opt(x.causedBy.isPresent() ? x.causedBy.get().clone() : null);
        this.hash = x.hash;
        this.count = new AtomicInteger(x.count.get());
        this.firstOccurrence = new AtomicLong(x.firstOccurrence.get());
        this.lastOccurrence = new AtomicLong(x.lastOccurrence.get());
    }

    protected ThrownStats(Builder builder) {
        this.guid = new Random().nextLong();
        this.thrownClass = builder.throwable.getClass();
        this.firstMessage = builder.throwable.getMessage();
        this.stackTrace = CollectionUtils.u(CollectionUtils.copyOf(builder.stackTrace));
        this.causedBy = Utils.opt(builder.causedBy);
        this.hash = builder.hash;
        this.count = new AtomicInteger(0);
        long ct = System.currentTimeMillis();
        this.firstOccurrence = new AtomicLong(ct);
        this.lastOccurrence = new AtomicLong(ct);
    }

    public ThrownStats clone() {
        return new ThrownStats(this);
    }

    public Optional<ThrownStats> getCausedBy() {
        return this.causedBy;
    }

    public int getCount() {
        return this.count.intValue();
    }

    public String getFirstMessage() {
        return this.firstMessage;
    }

    public long getFirstOccurrence() {
        return this.firstOccurrence.longValue();
    }

    public long getGuid() {
        return this.guid;
    }

    public long getHash() {
        return this.hash;
    }

    public long getLastOccurrence() {
        return this.lastOccurrence.longValue();
    }

    public List<String> getStackTrace() {
        return this.stackTrace;
    }

    public Class<?> getThrownClass() {
        return this.thrownClass;
    }

    public ThrownStats increment() {
        this.count.incrementAndGet();
        this.lastOccurrence.set(System.currentTimeMillis());
        this.causedBy.ifPresent(ThrownStats::increment);
        return this;
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a("causedBy", this.causedBy.orElse(null)).a("count", this.getCount()).a("firstMessage", this.firstMessage).a("firstOccurrence", this.getFirstOccurrence()).a("guid", this.guid).a("hash", this.hash).a("lastOccurrence", this.getLastOccurrence()).a("stackTrace", this.stackTrace).a("thrownClass", (List<String>)((Object)this.thrownClass));
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    public static class Builder {
        final BeanStore beanStore;
        Throwable throwable;
        long hash;
        List<String> stackTrace;
        ThrownStats causedBy;
        BeanCreator<ThrownStats> creator;

        protected Builder(BeanStore beanStore) {
            this.beanStore = beanStore;
            this.creator = beanStore.createBean(ThrownStats.class).builder(Builder.class, this);
        }

        public ThrownStats build() {
            return this.creator.run();
        }

        public Builder causedBy(ThrownStats value) {
            this.causedBy = value;
            return this;
        }

        public Builder hash(long value) {
            this.hash = value;
            return this;
        }

        public Builder stackTrace(List<String> value) {
            this.stackTrace = value;
            return this;
        }

        public Builder throwable(Throwable value) {
            this.throwable = value;
            return this;
        }

        public Builder type(Class<? extends ThrownStats> value) {
            this.creator.type(value == null ? ThrownStats.class : value);
            return this;
        }
    }
}

