/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.part.BasicPart;

public class BasicLongPart
extends BasicPart {
    private final Long value;
    private final Supplier<Long> supplier;

    public static BasicLongPart of(String name, Long value) {
        if (Utils.e(name) || value == null) {
            return null;
        }
        return new BasicLongPart(name, value);
    }

    public static BasicLongPart of(String name, Supplier<Long> value) {
        if (Utils.e(name) || value == null) {
            return null;
        }
        return new BasicLongPart(name, value);
    }

    public BasicLongPart(String name, Long value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicLongPart(String name, String value) {
        super(name, value);
        this.value = Utils.e(value) ? null : Long.valueOf(value);
        this.supplier = null;
    }

    public BasicLongPart(String name, Supplier<Long> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
    }

    public Optional<Long> asLong() {
        return Utils.opt(this.value());
    }

    public FluentLongAssertion<BasicLongPart> assertLong() {
        return new FluentLongAssertion<BasicLongPart>(this.value(), this);
    }

    @Override
    public String getValue() {
        return Utils.s(this.value());
    }

    public Long orElse(Long other) {
        Long x = this.value();
        return Utils.nn(x) ? x : other;
    }

    public Long toLong() {
        return this.value();
    }

    private Long value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

