/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.statistics.sampled;

import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.sampled.CacheStatisticsSampler;
import net.sf.ehcache.statistics.sampled.NullSampledCacheStatistics;
import net.sf.ehcache.statistics.sampled.SampledCacheStatistics;
import net.sf.ehcache.statistics.sampled.SampledCacheStatisticsImpl;
import net.sf.ehcache.util.FailSafeTimer;
import net.sf.ehcache.util.counter.sampled.SampledCounter;
import net.sf.ehcache.util.counter.sampled.SampledCounterConfig;
import net.sf.ehcache.util.counter.sampled.SampledRateCounter;
import net.sf.ehcache.util.counter.sampled.SampledRateCounterConfig;

public class SampledCacheStatisticsWrapper
implements CacheUsageListener,
CacheStatisticsSampler {
    private static final NullSampledCacheStatistics NULL_SAMPLED_CACHE_STATISTICS = new NullSampledCacheStatistics();
    private volatile SampledCacheStatistics delegate = new NullSampledCacheStatistics();
    private volatile CacheStatisticsSampler samplerDelegate;

    public void enableSampledStatistics(FailSafeTimer timer) {
        this.enableSampledStatistics(new SampledCacheStatisticsImpl(timer));
    }

    public void enableSampledStatistics(FailSafeTimer timer, SampledCounterConfig config, SampledRateCounterConfig rateGetConfig, SampledRateCounterConfig rateSearchConfig) {
        this.enableSampledStatistics(new SampledCacheStatisticsImpl(timer, config, rateGetConfig, rateSearchConfig));
    }

    private void enableSampledStatistics(SampledCacheStatisticsImpl sampledCacheStats) {
        this.delegate.dispose();
        this.samplerDelegate = sampledCacheStats;
        this.delegate = sampledCacheStats;
    }

    public void disableSampledStatistics() {
        this.delegate.dispose();
        this.delegate = NULL_SAMPLED_CACHE_STATISTICS;
        this.samplerDelegate = null;
    }

    @Override
    public boolean isSampledStatisticsEnabled() {
        return this.delegate instanceof SampledCacheStatisticsImpl;
    }

    @Override
    public void dispose() {
        this.delegate.dispose();
    }

    @Override
    public long getAverageGetTimeMostRecentSample() {
        return this.delegate.getAverageGetTimeMostRecentSample();
    }

    @Override
    public long getAverageGetTimeNanosMostRecentSample() {
        return this.delegate.getAverageGetTimeNanosMostRecentSample();
    }

    @Override
    public long getCacheElementEvictedMostRecentSample() {
        return this.delegate.getCacheElementEvictedMostRecentSample();
    }

    @Override
    public long getCacheElementExpiredMostRecentSample() {
        return this.delegate.getCacheElementExpiredMostRecentSample();
    }

    @Override
    public long getCacheElementPutMostRecentSample() {
        return this.delegate.getCacheElementPutMostRecentSample();
    }

    @Override
    public long getCacheElementRemovedMostRecentSample() {
        return this.delegate.getCacheElementRemovedMostRecentSample();
    }

    @Override
    public long getCacheElementUpdatedMostRecentSample() {
        return this.delegate.getCacheElementUpdatedMostRecentSample();
    }

    @Override
    public long getCacheHitInMemoryMostRecentSample() {
        return this.delegate.getCacheHitInMemoryMostRecentSample();
    }

    @Override
    public long getCacheHitOffHeapMostRecentSample() {
        return this.delegate.getCacheHitOffHeapMostRecentSample();
    }

    @Override
    public long getCacheHitMostRecentSample() {
        return this.delegate.getCacheHitMostRecentSample();
    }

    @Override
    public long getCacheHitOnDiskMostRecentSample() {
        return this.delegate.getCacheHitOnDiskMostRecentSample();
    }

    @Override
    public long getCacheMissExpiredMostRecentSample() {
        return this.delegate.getCacheMissExpiredMostRecentSample();
    }

    @Override
    public long getCacheMissMostRecentSample() {
        return this.delegate.getCacheMissMostRecentSample();
    }

    @Override
    public long getCacheMissInMemoryMostRecentSample() {
        return this.delegate.getCacheMissInMemoryMostRecentSample();
    }

    @Override
    public long getCacheMissOffHeapMostRecentSample() {
        return this.delegate.getCacheMissOffHeapMostRecentSample();
    }

    @Override
    public long getCacheMissOnDiskMostRecentSample() {
        return this.delegate.getCacheMissOnDiskMostRecentSample();
    }

    @Override
    public long getCacheMissNotFoundMostRecentSample() {
        return this.delegate.getCacheMissNotFoundMostRecentSample();
    }

    @Override
    public int getStatisticsAccuracy() {
        return this.delegate.getStatisticsAccuracy();
    }

    @Override
    public void clearStatistics() {
        this.delegate.clearStatistics();
    }

    @Override
    public String getStatisticsAccuracyDescription() {
        return this.delegate.getStatisticsAccuracyDescription();
    }

    private CacheUsageListener getDelegateAsListener() {
        return (CacheUsageListener)((Object)this.delegate);
    }

    @Override
    public void notifyCacheElementEvicted() {
        this.getDelegateAsListener().notifyCacheElementEvicted();
    }

    @Override
    public void notifyCacheElementExpired() {
        this.getDelegateAsListener().notifyCacheElementExpired();
    }

    @Override
    public void notifyCacheElementPut() {
        this.getDelegateAsListener().notifyCacheElementPut();
    }

    @Override
    public void notifyCacheElementRemoved() {
        this.getDelegateAsListener().notifyCacheElementRemoved();
    }

    @Override
    public void notifyCacheElementUpdated() {
        this.getDelegateAsListener().notifyCacheElementUpdated();
    }

    @Override
    public void notifyCacheHitInMemory() {
        this.getDelegateAsListener().notifyCacheHitInMemory();
    }

    @Override
    public void notifyCacheHitOffHeap() {
        this.getDelegateAsListener().notifyCacheHitOffHeap();
    }

    @Override
    public void notifyCacheHitOnDisk() {
        this.getDelegateAsListener().notifyCacheHitOnDisk();
    }

    @Override
    public void notifyCacheMissedWithExpired() {
        this.getDelegateAsListener().notifyCacheMissedWithExpired();
    }

    @Override
    public void notifyCacheMissedWithNotFound() {
        this.getDelegateAsListener().notifyCacheMissedWithNotFound();
    }

    @Override
    public void notifyCacheMissInMemory() {
        this.getDelegateAsListener().notifyCacheMissInMemory();
    }

    @Override
    public void notifyCacheMissOffHeap() {
        this.getDelegateAsListener().notifyCacheMissOffHeap();
    }

    @Override
    public void notifyCacheMissOnDisk() {
        this.getDelegateAsListener().notifyCacheMissOnDisk();
    }

    @Override
    public void notifyRemoveAll() {
        this.getDelegateAsListener().notifyRemoveAll();
    }

    @Override
    public void notifyStatisticsAccuracyChanged(int statisticsAccuracy) {
        this.getDelegateAsListener().notifyStatisticsAccuracyChanged(statisticsAccuracy);
    }

    @Override
    public void notifyStatisticsCleared() {
        this.getDelegateAsListener().notifyStatisticsCleared();
    }

    @Override
    public void notifyStatisticsEnabledChanged(boolean enableStatistics) {
        this.getDelegateAsListener().notifyStatisticsEnabledChanged(enableStatistics);
    }

    @Override
    public void notifyTimeTakenForGet(long millis) {
    }

    @Override
    public void notifyGetTimeNanos(long nanos) {
        this.getDelegateAsListener().notifyGetTimeNanos(nanos);
    }

    @Override
    public long getAverageSearchTime() {
        return this.delegate.getAverageSearchTime();
    }

    @Override
    public long getSearchesPerSecond() {
        return this.delegate.getSearchesPerSecond();
    }

    @Override
    public void notifyCacheSearch(long executeTime) {
        this.getDelegateAsListener().notifyCacheSearch(executeTime);
    }

    @Override
    public void notifyXaCommit() {
        this.getDelegateAsListener().notifyXaCommit();
    }

    @Override
    public void notifyXaRollback() {
        this.getDelegateAsListener().notifyXaRollback();
    }

    @Override
    public long getCacheXaCommitsMostRecentSample() {
        return this.delegate.getCacheXaCommitsMostRecentSample();
    }

    @Override
    public long getCacheXaRollbacksMostRecentSample() {
        return this.delegate.getCacheXaRollbacksMostRecentSample();
    }

    @Override
    public SampledCounter getCacheHitSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheHitSample();
    }

    @Override
    public SampledCounter getCacheHitInMemorySample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheHitInMemorySample();
    }

    @Override
    public SampledCounter getCacheHitOffHeapSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheHitOffHeapSample();
    }

    @Override
    public SampledCounter getCacheHitOnDiskSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheHitOnDiskSample();
    }

    @Override
    public SampledCounter getCacheMissSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheMissSample();
    }

    @Override
    public SampledCounter getCacheMissInMemorySample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheHitInMemorySample();
    }

    @Override
    public SampledCounter getCacheMissOffHeapSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheMissOffHeapSample();
    }

    @Override
    public SampledCounter getCacheMissOnDiskSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheMissOnDiskSample();
    }

    @Override
    public SampledCounter getCacheMissExpiredSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheMissExpiredSample();
    }

    @Override
    public SampledCounter getCacheMissNotFoundSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheMissNotFoundSample();
    }

    @Override
    public SampledCounter getCacheElementEvictedSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheElementEvictedSample();
    }

    @Override
    public SampledCounter getCacheElementRemovedSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheElementRemovedSample();
    }

    @Override
    public SampledCounter getCacheElementExpiredSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheElementExpiredSample();
    }

    @Override
    public SampledCounter getCacheElementPutSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheElementPutSample();
    }

    @Override
    public SampledCounter getCacheElementUpdatedSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheElementUpdatedSample();
    }

    @Override
    public SampledRateCounter getAverageGetTimeSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getAverageGetTimeSample();
    }

    @Override
    public SampledRateCounter getAverageGetTimeNanosSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getAverageGetTimeNanosSample();
    }

    @Override
    public SampledRateCounter getAverageSearchTimeSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getAverageSearchTimeSample();
    }

    @Override
    public SampledCounter getSearchesPerSecondSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getSearchesPerSecondSample();
    }

    @Override
    public SampledCounter getCacheXaCommitsSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheXaCommitsSample();
    }

    @Override
    public SampledCounter getCacheXaRollbacksSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheXaRollbacksSample();
    }

    @Override
    public int getCacheHitRatioMostRecentSample() {
        return this.delegate.getCacheHitRatioMostRecentSample();
    }

    @Override
    public SampledCounter getCacheHitRatioSample() {
        return this.samplerDelegate == null ? null : this.samplerDelegate.getCacheHitRatioSample();
    }
}

