/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage.macos;

import java.nio.file.Path;
import java.util.ResourceBundle;
import org.apache.netbeans.nbpackage.Option;
import org.apache.netbeans.nbpackage.Template;
import org.apache.netbeans.nbpackage.macos.PkgPackager;

class MacOS {
    private static final String DEFAULT_BIN_GLOB = "{*.dylib,*.jnilib,**/nativeexecution/MacOSX-*/*,Contents/Home/bin/*,Contents/Home/lib/jspawnhelper}";
    private static final String DEFAULT_JAR_BIN_GLOB = "{flatlaf-*.jar,jna-5*.jar,junixsocket-native-common-*.jar,launcher-common-*.jar,jansi-*.jar,nbi-engine.jar,truffle-runtime-*.jar}";
    static final ResourceBundle MESSAGES = ResourceBundle.getBundle(PkgPackager.class.getPackageName() + ".Messages");
    static final Option<String> BUNDLE_ID = Option.ofString("package.macos.bundleid", MESSAGES.getString("option.bundle_id.help"));
    static final Option<Path> ICON_PATH = Option.ofPath("package.macos.icon", MESSAGES.getString("option.icon.help"));
    static final Option<Path> INFO_TEMPLATE_PATH = Option.ofPath("package.macos.info-template", MESSAGES.getString("option.info_template.help"));
    static final Template INFO_TEMPLATE = Template.of(INFO_TEMPLATE_PATH, "Info.plist.template", () -> MacOS.class.getResourceAsStream("Info.plist.template"));
    static final Option<Path> LAUNCHER_TEMPLATE_PATH = Option.ofPath("package.macos.launcher-template", MESSAGES.getString("option.launcher_template.help"));
    static final Template LAUNCHER_TEMPLATE = Template.of(LAUNCHER_TEMPLATE_PATH, "main.swift.template", () -> MacOS.class.getResourceAsStream("main.swift.template"));
    static final Option<Path> LAUNCHER_PACKAGE_TEMPLATE_PATH = Option.ofPath("package.macos.launcher-package-template", "");
    static final Template LAUNCHER_PACKAGE_TEMPLATE = Template.of(LAUNCHER_PACKAGE_TEMPLATE_PATH, "Package.swift.template", () -> MacOS.class.getResourceAsStream("Package.swift.template"));
    static final Option<Path> ENTITLEMENTS_TEMPLATE_PATH = Option.ofPath("package.macos.entitlements-template", MESSAGES.getString("option.entitlements_template.help"));
    static final Template ENTITLEMENTS_TEMPLATE = Template.of(ENTITLEMENTS_TEMPLATE_PATH, "sandbox.plist.template", () -> MacOS.class.getResourceAsStream("sandbox.plist.template"));
    static final Option<String> SIGNING_FILES = Option.ofString("package.macos.codesign-files", "{*.dylib,*.jnilib,**/nativeexecution/MacOSX-*/*,Contents/Home/bin/*,Contents/Home/lib/jspawnhelper}", MESSAGES.getString("option.codesign_files.help"));
    static final Option<String> SIGNING_JARS = Option.ofString("package.macos.codesign-jars", "{flatlaf-*.jar,jna-5*.jar,junixsocket-native-common-*.jar,launcher-common-*.jar,jansi-*.jar,nbi-engine.jar,truffle-runtime-*.jar}", MESSAGES.getString("option.codesign_jars.help"));
    static final Option<String> CODESIGN_ID = Option.ofString("package.macos.codesign-id", MESSAGES.getString("option.codesign_id.help"));
    static final Option<String> PKGBUILD_ID = Option.ofString("package.macos.pkgbuild-id", MESSAGES.getString("option.pkgbuild_id.help"));

    private MacOS() {
    }
}

