/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchemaWithIdAndName;
import org.apache.nifi.minifi.toolkit.schema.common.CommonPropertyKeys;
import org.apache.nifi.scheduling.SchedulingStrategy;

public class ReportingSchema
extends BaseSchemaWithIdAndName {
    private String schedulingStrategy;
    private String schedulingPeriod;
    private String comment;
    private String reportingClass;
    private Map<String, Object> properties = CommonPropertyKeys.DEFAULT_PROPERTIES;

    public ReportingSchema(Map map) {
        super(map, "Reporting(id: {id}, name: {name})");
        if (this.getId().equals("")) {
            this.setId(UUID.randomUUID().toString());
        }
        String wrapperName = this.getWrapperName();
        this.reportingClass = this.getRequiredKeyAsType(map, "class", String.class, wrapperName);
        this.schedulingStrategy = this.getRequiredKeyAsType(map, "scheduling strategy", String.class, wrapperName);
        if (this.schedulingStrategy != null && !ReportingSchema.isSchedulingStrategy(this.schedulingStrategy)) {
            this.addValidationIssue("scheduling strategy", wrapperName, "it is not a valid scheduling strategy");
        }
        this.schedulingPeriod = this.getRequiredKeyAsType(map, "scheduling period", String.class, wrapperName);
        this.comment = this.getOptionalKeyAsType(map, "comment", String.class, wrapperName, "");
        this.properties = this.getOptionalKeyAsType(map, "Properties", Map.class, wrapperName, CommonPropertyKeys.DEFAULT_PROPERTIES);
    }

    public static boolean isSchedulingStrategy(String string) {
        try {
            SchedulingStrategy.valueOf((String)string);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> result = super.toMap();
        result.put("class", this.reportingClass);
        result.put("comment", this.comment);
        result.put("scheduling strategy", this.schedulingStrategy);
        result.put("scheduling period", this.schedulingPeriod);
        result.put("Properties", new HashMap<String, Object>(this.properties));
        return result;
    }

    public String getComment() {
        return this.comment;
    }

    public String getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod;
    }

    public String getReportingClass() {
        return this.reportingClass;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

