/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.cs;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ControllerServiceResult;
import org.apache.nifi.toolkit.client.ControllerServicesClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;

public class GetControllerService
extends AbstractNiFiCommand<ControllerServiceResult> {
    public GetControllerService() {
        super("get-service", ControllerServiceResult.class);
    }

    @Override
    public String getDescription() {
        return "Retrieves the status for a controller service.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.CS_ID.createOption());
    }

    @Override
    public ControllerServiceResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String csId = this.getRequiredArg(properties, CommandOption.CS_ID);
        ControllerServicesClient csClient = client.getControllerServicesClient();
        ControllerServiceEntity csEntityResult = csClient.getControllerService(csId);
        return new ControllerServiceResult(this.getResultType(properties), csEntityResult);
    }
}

