/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.h2.command.dml.ScriptBase;
import org.h2.command.dml.SetTypes;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.SessionLocal;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Constant;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.schema.UserDefinedFunction;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueVarchar;

public class ScriptCommand
extends ScriptBase {
    private static final Comparator<? super DbObject> BY_NAME_COMPARATOR = (dbObject, dbObject2) -> {
        int n;
        if (dbObject instanceof SchemaObject && dbObject2 instanceof SchemaObject && (n = ((SchemaObject)dbObject).getSchema().getName().compareTo(((SchemaObject)dbObject2).getSchema().getName())) != 0) {
            return n;
        }
        return dbObject.getName().compareTo(dbObject2.getName());
    };
    private Charset charset = StandardCharsets.UTF_8;
    private Set<String> schemaNames;
    private Collection<Table> tables;
    private boolean passwords;
    private boolean data;
    private boolean settings;
    private boolean drop;
    private boolean simple;
    private boolean withColumns;
    private boolean version = true;
    private LocalResult result;
    private String lineSeparatorString;
    private byte[] lineSeparator;
    private byte[] buffer;
    private boolean tempLobTableCreated;
    private int nextLobId;
    private int lobBlockSize = 4096;

    public ScriptCommand(SessionLocal sessionLocal) {
        super(sessionLocal);
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    public void setSchemaNames(Set<String> set) {
        this.schemaNames = set;
    }

    public void setTables(Collection<Table> collection) {
        this.tables = collection;
    }

    public void setData(boolean bl) {
        this.data = bl;
    }

    public void setPasswords(boolean bl) {
        this.passwords = bl;
    }

    public void setSettings(boolean bl) {
        this.settings = bl;
    }

    public void setLobBlockSize(long l) {
        this.lobBlockSize = MathUtils.convertLongToInt(l);
    }

    public void setDrop(boolean bl) {
        this.drop = bl;
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult localResult = this.createResult();
        localResult.done();
        return localResult;
    }

    private LocalResult createResult() {
        return new LocalResult(this.session, new Expression[]{new ExpressionColumn(this.getDatabase(), new Column("SCRIPT", TypeInfo.TYPE_VARCHAR))}, 1, 1);
    }

    @Override
    public ResultInterface query(long l) {
        Object object;
        this.session.getUser().checkAdmin();
        this.reset();
        Database database = this.getDatabase();
        if (this.schemaNames != null) {
            for (String object22 : this.schemaNames) {
                Schema schema = database.findSchema(object22);
                if (schema != null) continue;
                throw DbException.get(90079, object22);
            }
        }
        try {
            Object object22;
            this.result = this.createResult();
            this.deleteStore();
            this.openOutput();
            if (this.out != null) {
                this.buffer = new byte[4096];
            }
            if (this.version) {
                this.add("-- H2 " + Constants.VERSION, true);
            }
            if (this.settings) {
                for (Setting setting : database.getAllSettings()) {
                    if (setting.getName().equals(SetTypes.getTypeName(28))) continue;
                    this.add(setting.getCreateSQL(), false);
                }
            }
            if (this.out != null) {
                this.add("", true);
            }
            object = database.getAllUsersAndRoles().toArray(new RightOwner[0]);
            Arrays.sort(object, (rightOwner, rightOwner2) -> {
                boolean bl = rightOwner instanceof User;
                if (bl != rightOwner2 instanceof User) {
                    return bl ? -1 : 1;
                }
                if (bl && (bl = ((User)rightOwner).isAdmin()) != ((User)rightOwner2).isAdmin()) {
                    return bl ? -1 : 1;
                }
                return rightOwner.getName().compareTo(rightOwner2.getName());
            });
            for (Object object22 : object) {
                if (object22 instanceof User) {
                    this.add(((User)object22).getCreateSQL(this.passwords), false);
                    continue;
                }
                this.add(((Role)object22).getCreateSQL(true), false);
            }
            ArrayList<Schema> arrayList = new ArrayList<Schema>();
            for (Schema schema : database.getAllSchemas()) {
                if (this.excludeSchema(schema)) continue;
                arrayList.add(schema);
                this.add(schema.getCreateSQL(), false);
            }
            this.dumpDomains(arrayList);
            for (Schema schema : arrayList) {
                for (Constant constant : (Constant[])ScriptCommand.sorted(schema.getAllConstants(), Constant.class)) {
                    this.add(constant.getCreateSQL(), false);
                }
            }
            ArrayList<Table> arrayList2 = database.getAllTablesAndViews();
            arrayList2.sort(Comparator.comparingInt(DbObject::getId));
            Iterator<Object> iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                object22 = (Table)iterator.next();
                if (this.excludeSchema(((SchemaObject)object22).getSchema()) || this.excludeTable((Table)object22)) continue;
                ((Table)object22).lock(this.session, 0);
                String iterator2 = ((DbObject)object22).getCreateSQL();
                if (iterator2 == null || !this.drop) continue;
                this.add(((DbObject)object22).getDropSQL(), false);
            }
            for (Object object22 : arrayList) {
                for (UserDefinedFunction userDefinedFunction : (UserDefinedFunction[])ScriptCommand.sorted(((Schema)object22).getAllFunctionsAndAggregates(), UserDefinedFunction.class)) {
                    if (this.drop) {
                        this.add(userDefinedFunction.getDropSQL(), false);
                    }
                    this.add(userDefinedFunction.getCreateSQL(), false);
                }
            }
            for (Object object22 : arrayList) {
                for (Sequence sequence : (Sequence[])ScriptCommand.sorted(((Schema)object22).getAllSequences(), Sequence.class)) {
                    if (sequence.getBelongsToTable()) continue;
                    if (this.drop) {
                        this.add(sequence.getDropSQL(), false);
                    }
                    this.add(sequence.getCreateSQL(), false);
                }
            }
            int n = 0;
            object22 = arrayList2.iterator();
            while (object22.hasNext()) {
                Table table = (Table)object22.next();
                if (this.excludeSchema(table.getSchema()) || this.excludeTable(table)) continue;
                table.lock(this.session, 0);
                String comment = table.getCreateSQL();
                if (comment == null) continue;
                TableType tableType = table.getTableType();
                this.add(comment, false);
                for (Constraint constraint : table.getConstraints()) {
                    if (Constraint.Type.PRIMARY_KEY != constraint.getConstraintType()) continue;
                    this.add(constraint.getCreateSQLWithoutIndexes(), false);
                }
                if (TableType.TABLE == tableType) {
                    if (table.canGetRowCount(this.session)) {
                        StringBuilder stringBuilder = new StringBuilder("-- ").append(table.getRowCountApproximation(this.session)).append(" +/- SELECT COUNT(*) FROM ");
                        table.getSQL(stringBuilder, 3);
                        this.add(stringBuilder.toString(), false);
                    }
                    if (this.data) {
                        n = this.generateInsertValues(n, table);
                    }
                }
                for (Index index : table.getIndexes()) {
                    if (index.getIndexType().getBelongsToConstraint()) continue;
                    this.add(index.getCreateSQL(), false);
                }
            }
            if (this.tempLobTableCreated) {
                this.add("DROP TABLE IF EXISTS SYSTEM_LOB_STREAM", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_CLOB", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_BLOB", true);
                this.tempLobTableCreated = false;
            }
            object22 = new ArrayList();
            for (Schema schema : arrayList) {
                for (Constraint constraint : schema.getAllConstraints()) {
                    if (this.excludeTable(constraint.getTable()) || constraint.getConstraintType() == Constraint.Type.PRIMARY_KEY) continue;
                    ((ArrayList)object22).add(constraint);
                }
            }
            ((ArrayList)object22).sort(null);
            Iterator<DbObject> iterator2 = ((ArrayList)object22).iterator();
            while (iterator2.hasNext()) {
                Constraint constraint = (Constraint)((Object)iterator2.next());
                this.add(constraint.getCreateSQLWithoutIndexes(), false);
            }
            for (Schema schema : arrayList) {
                for (TriggerObject triggerObject : schema.getAllTriggers()) {
                    if (this.excludeTable(triggerObject.getTable())) continue;
                    this.add(triggerObject.getCreateSQL(), false);
                }
            }
            this.dumpRights(database);
            for (Comment comment : database.getAllComments()) {
                this.add(comment.getCreateSQL(), false);
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.getFileName());
        }
        finally {
            this.closeIO();
        }
        this.result.done();
        object = this.result;
        this.reset();
        return object;
    }

    private void dumpDomains(ArrayList<Schema> arrayList) throws IOException {
        TreeMap<DbObject, TreeSet<? super DbObject>> treeMap = new TreeMap<DbObject, TreeSet<? super DbObject>>(BY_NAME_COMPARATOR);
        Object object = new TreeSet<DbObject>(BY_NAME_COMPARATOR);
        for (Schema object2 : arrayList) {
            for (Domain domain3 : (Domain[])ScriptCommand.sorted(object2.getAllDomains(), Domain.class)) {
                Domain domain2 = domain3.getDomain();
                if (domain2 == null) {
                    this.addDomain(domain3);
                    continue;
                }
                TreeSet<? super DbObject> treeSet = (TreeSet<? super DbObject>)treeMap.get(domain2);
                if (treeSet == null) {
                    treeSet = new TreeSet<DbObject>(BY_NAME_COMPARATOR);
                    treeMap.put(domain2, treeSet);
                }
                treeSet.add(domain3);
                if (domain2.getDomain() != null && arrayList.contains(domain2.getSchema())) continue;
                ((TreeSet)object).add(domain2);
            }
        }
        while (!treeMap.isEmpty()) {
            TreeSet<? super DbObject> treeSet = new TreeSet<DbObject>(BY_NAME_COMPARATOR);
            Iterator<? super DbObject> iterator = ((TreeSet)object).iterator();
            while (iterator.hasNext()) {
                Domain domain = (Domain)iterator.next();
                TreeSet treeSet2 = (TreeSet)treeMap.remove(domain);
                if (treeSet2 == null) continue;
                for (Domain domain3 : treeSet2) {
                    this.addDomain(domain3);
                    treeSet.add(domain3);
                }
            }
            object = treeSet;
        }
    }

    private void dumpRights(Database database) throws IOException {
        Right[] rightArray = database.getAllRights().toArray(new Right[0]);
        Arrays.sort(rightArray, (right, right2) -> {
            Role role;
            Role role2 = right.getGrantedRole();
            if (role2 == null != ((role = right2.getGrantedRole()) == null)) {
                return role2 == null ? -1 : 1;
            }
            if (role2 == null) {
                DbObject dbObject;
                DbObject dbObject2 = right.getGrantedObject();
                if (dbObject2 == null != ((dbObject = right2.getGrantedObject()) == null)) {
                    return dbObject2 == null ? -1 : 1;
                }
                if (dbObject2 != null) {
                    if (dbObject2 instanceof Schema != dbObject instanceof Schema) {
                        return dbObject2 instanceof Schema ? -1 : 1;
                    }
                    int n = dbObject2.getName().compareTo(dbObject.getName());
                    if (n != 0) {
                        return n;
                    }
                }
            } else {
                int n = role2.getName().compareTo(role.getName());
                if (n != 0) {
                    return n;
                }
            }
            return right.getGrantee().getName().compareTo(right2.getGrantee().getName());
        });
        for (Right right3 : rightArray) {
            Table table;
            DbObject dbObject = right3.getGrantedObject();
            if (dbObject != null && (dbObject instanceof Schema ? this.excludeSchema((Schema)dbObject) : dbObject instanceof Table && (this.excludeSchema((table = (Table)dbObject).getSchema()) || this.excludeTable(table)))) continue;
            this.add(right3.getCreateSQL(), false);
        }
    }

    private void addDomain(Domain domain) throws IOException {
        if (this.drop) {
            this.add(domain.getDropSQL(), false);
        }
        this.add(domain.getCreateSQL(), false);
    }

    private static <T extends DbObject> T[] sorted(Collection<T> collection, Class<T> clazz) {
        DbObject[] dbObjectArray = collection.toArray((DbObject[])Array.newInstance(clazz, 0));
        Arrays.sort(dbObjectArray, BY_NAME_COMPARATOR);
        return dbObjectArray;
    }

    private int generateInsertValues(int n, Table table) throws IOException {
        PlanItem planItem = table.getBestPlanItem(this.session, null, null, -1, null, null, true);
        Index index = planItem.getIndex();
        Cursor cursor = index.find(this.session, null, null, false);
        Column[] columnArray = table.getColumns();
        boolean bl = false;
        boolean bl2 = false;
        for (Column column : columnArray) {
            if (!column.isGeneratedAlways()) continue;
            if (column.isIdentity()) {
                bl2 = true;
                continue;
            }
            bl = true;
        }
        Object object = new StringBuilder("INSERT INTO ");
        table.getSQL((StringBuilder)object, 0);
        if (bl || bl2 || this.withColumns) {
            ((StringBuilder)object).append('(');
            int n2 = 0;
            for (Column column : columnArray) {
                if (column.isGenerated()) continue;
                if (n2 != 0) {
                    ((StringBuilder)object).append(", ");
                }
                n2 = 1;
                column.getSQL((StringBuilder)object, 0);
            }
            ((StringBuilder)object).append(')');
            if (bl2) {
                ((StringBuilder)object).append(" OVERRIDING SYSTEM VALUE");
            }
        }
        ((StringBuilder)object).append(" VALUES");
        if (!this.simple) {
            ((StringBuilder)object).append('\n');
        }
        ((StringBuilder)object).append('(');
        String string = ((StringBuilder)object).toString();
        object = null;
        int n3 = columnArray.length;
        while (cursor.next()) {
            Row row = cursor.get();
            if (object == null) {
                object = new StringBuilder(string);
            } else {
                ((StringBuilder)object).append(",\n(");
            }
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                if (columnArray[i].isGenerated()) continue;
                if (n4 != 0) {
                    ((StringBuilder)object).append(", ");
                }
                n4 = 1;
                Value value = row.getValue(i);
                if (value.getType().getPrecision() > (long)this.lobBlockSize) {
                    int n5;
                    if (value.getValueType() == 3) {
                        n5 = this.writeLobStream(value);
                        ((StringBuilder)object).append("SYSTEM_COMBINE_CLOB(").append(n5).append(')');
                        continue;
                    }
                    if (value.getValueType() == 7) {
                        n5 = this.writeLobStream(value);
                        ((StringBuilder)object).append("SYSTEM_COMBINE_BLOB(").append(n5).append(')');
                        continue;
                    }
                    value.getSQL((StringBuilder)object, 4);
                    continue;
                }
                value.getSQL((StringBuilder)object, 4);
            }
            ((StringBuilder)object).append(')');
            if ((++n & 0x7F) == 0) {
                this.checkCanceled();
            }
            if (!this.simple && ((StringBuilder)object).length() <= 4096) continue;
            this.add(((StringBuilder)object).toString(), true);
            object = null;
        }
        if (object != null) {
            this.add(((StringBuilder)object).toString(), true);
        }
        return n;
    }

    private int writeLobStream(Value value) throws IOException {
        if (!this.tempLobTableCreated) {
            this.add("CREATE CACHED LOCAL TEMPORARY TABLE IF NOT EXISTS SYSTEM_LOB_STREAM(ID INT NOT NULL, PART INT NOT NULL, CDATA VARCHAR, BDATA VARBINARY)", true);
            this.add("ALTER TABLE SYSTEM_LOB_STREAM ADD CONSTRAINT SYSTEM_LOB_STREAM_PRIMARY_KEY PRIMARY KEY(ID, PART)", true);
            String string = this.getClass().getName();
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_CLOB FOR '" + string + ".combineClob'", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_BLOB FOR '" + string + ".combineBlob'", true);
            this.tempLobTableCreated = true;
        }
        int n = this.nextLobId++;
        block4 : switch (value.getValueType()) {
            case 7: {
                byte[] byArray = new byte[this.lobBlockSize];
                try (InputStream inputStream = value.getInputStream();){
                    int n2 = 0;
                    while (true) {
                        StringBuilder stringBuilder = new StringBuilder(this.lobBlockSize * 2);
                        stringBuilder.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(").append(n).append(", ").append(n2).append(", NULL, X'");
                        int n3 = IOUtils.readFully(inputStream, byArray, this.lobBlockSize);
                        if (n3 <= 0) {
                            break block4;
                        }
                        StringUtils.convertBytesToHex(stringBuilder, byArray, n3).append("')");
                        String string = stringBuilder.toString();
                        this.add(string, true);
                        ++n2;
                    }
                }
            }
            case 3: {
                char[] cArray = new char[this.lobBlockSize];
                try (Reader reader = value.getReader();){
                    int n4 = 0;
                    while (true) {
                        StringBuilder stringBuilder = new StringBuilder(this.lobBlockSize * 2);
                        stringBuilder.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(").append(n).append(", ").append(n4).append(", ");
                        int n5 = IOUtils.readFully(reader, cArray, this.lobBlockSize);
                        if (n5 == 0) {
                            break block4;
                        }
                        StringUtils.quoteStringSQL(stringBuilder, new String(cArray, 0, n5)).append(", NULL)");
                        String string = stringBuilder.toString();
                        this.add(string, true);
                        ++n4;
                    }
                }
            }
            default: {
                throw DbException.getInternalError("type:" + value.getValueType());
            }
        }
        return n;
    }

    public static InputStream combineBlob(Connection connection, int n) throws SQLException {
        if (n < 0) {
            return null;
        }
        final ResultSet resultSet = ScriptCommand.getLobStream(connection, "BDATA", n);
        return new InputStream(){
            private InputStream current;
            private boolean closed;

            @Override
            public int read() throws IOException {
                try {
                    while (true) {
                        int n;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!resultSet.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = resultSet.getBinaryStream(1);
                            this.current = new BufferedInputStream(this.current);
                        }
                        if ((n = this.current.read()) >= 0) {
                            return n;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException sQLException) {
                    throw DataUtils.convertToIOException(sQLException);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    throw DataUtils.convertToIOException(sQLException);
                }
            }
        };
    }

    public static Reader combineClob(Connection connection, int n) throws SQLException {
        if (n < 0) {
            return null;
        }
        final ResultSet resultSet = ScriptCommand.getLobStream(connection, "CDATA", n);
        return new Reader(){
            private Reader current;
            private boolean closed;

            @Override
            public int read() throws IOException {
                try {
                    while (true) {
                        int n;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!resultSet.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = resultSet.getCharacterStream(1);
                            this.current = new BufferedReader(this.current);
                        }
                        if ((n = this.current.read()) >= 0) {
                            return n;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException sQLException) {
                    throw DataUtils.convertToIOException(sQLException);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    throw DataUtils.convertToIOException(sQLException);
                }
            }

            @Override
            public int read(char[] cArray, int n, int n2) throws IOException {
                int n3;
                if (n2 == 0) {
                    return 0;
                }
                int n4 = this.read();
                if (n4 == -1) {
                    return -1;
                }
                cArray[n] = (char)n4;
                for (n3 = 1; n3 < n2 && (n4 = this.read()) != -1; ++n3) {
                    cArray[n + n3] = (char)n4;
                }
                return n3;
            }
        };
    }

    private static ResultSet getLobStream(Connection connection, String string, int n) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT " + string + " FROM SYSTEM_LOB_STREAM WHERE ID=? ORDER BY PART");
        preparedStatement.setInt(1, n);
        return preparedStatement.executeQuery();
    }

    private void reset() {
        this.result = null;
        this.buffer = null;
        this.lineSeparatorString = System.lineSeparator();
        this.lineSeparator = this.lineSeparatorString.getBytes(this.charset);
    }

    private boolean excludeSchema(Schema schema) {
        if (this.schemaNames != null && !this.schemaNames.contains(schema.getName())) {
            return true;
        }
        if (this.tables != null) {
            for (Table table : schema.getAllTablesAndViews(this.session)) {
                if (!this.tables.contains(table)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean excludeTable(Table table) {
        return this.tables != null && !this.tables.contains(table);
    }

    private void add(String object, boolean bl) throws IOException {
        if (object == null) {
            return;
        }
        if (this.lineSeparator.length > 1 || this.lineSeparator[0] != 10) {
            object = StringUtils.replaceAll((String)object, "\n", this.lineSeparatorString);
        }
        object = (String)object + ";";
        if (this.out != null) {
            int n;
            byte[] byArray = ((String)object).getBytes(this.charset);
            int n2 = MathUtils.roundUpInt(byArray.length + this.lineSeparator.length, 16);
            this.buffer = Utils.copy(byArray, this.buffer);
            if (n2 > this.buffer.length) {
                this.buffer = new byte[n2];
            }
            System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
            for (n = byArray.length; n < n2 - this.lineSeparator.length; ++n) {
                this.buffer[n] = 32;
            }
            n = 0;
            int n3 = n2 - this.lineSeparator.length;
            while (n3 < n2) {
                this.buffer[n3] = this.lineSeparator[n];
                ++n3;
                ++n;
            }
            this.out.write(this.buffer, 0, n2);
            if (!bl) {
                this.result.addRow(ValueVarchar.get((String)object));
            }
        } else {
            this.result.addRow(ValueVarchar.get((String)object));
        }
    }

    public void setSimple(boolean bl) {
        this.simple = bl;
    }

    public void setWithColumns(boolean bl) {
        this.withColumns = bl;
    }

    public void setVersion(boolean bl) {
        this.version = bl;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public int getType() {
        return 65;
    }
}

