/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public class URLValidator
implements Validator {
    private static final String SCHEME_PATTERN = "([^:/?#]+):";
    private static final String USERINFO_PATTERN = "([^@\\[/?#]*)";
    private static final String HOST_IPV4_PATTERN = "[^\\[/?#:]*";
    private static final String HOST_IPV6_PATTERN = "\\[[\\p{XDigit}:.]*[%\\p{Alnum}]*]";
    private static final String HOST_PATTERN = "(\\[[\\p{XDigit}:.]*[%\\p{Alnum}]*]|[^\\[/?#:]*)";
    private static final String PORT_PATTERN = "(\\{[^}]+\\}?|[^/?#]*)";
    private static final String PATH_PATTERN = "([^?#]*)";
    private static final String QUERY_PATTERN = "([^#]*)";
    private static final String LAST_PATTERN = "(.*)";
    private static final Pattern URI_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//(([^@\\[/?#]*)@)?(\\[[\\p{XDigit}:.]*[%\\p{Alnum}]*]|[^\\[/?#:]*)(:(\\{[^}]+\\}?|[^/?#]*))?)?([^?#]*)(\\?([^#]*))?(#(.*))?");

    @Override
    public ValidationResult validate(String subject, String input, ValidationContext context) {
        if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
            return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
        }
        try {
            String evaluatedInput = context.newPropertyValue(input).evaluateAttributeExpressions().getValue();
            URLValidator.createURL(evaluatedInput);
            return new ValidationResult.Builder().subject(subject).input(input).explanation("Valid URL").valid(true).build();
        }
        catch (Exception e) {
            return new ValidationResult.Builder().subject(subject).input(input).explanation("Not a valid URL").valid(false).build();
        }
    }

    public static URL createURL(String url) throws MalformedURLException {
        Matcher matcher = URI_PATTERN.matcher(url);
        if (matcher.matches()) {
            String scheme = matcher.group(2);
            String userInfo = matcher.group(5);
            String host = matcher.group(6);
            String port = matcher.group(8);
            String path = matcher.group(9);
            String query = matcher.group(11);
            String fragment = matcher.group(13);
            try {
                return new URI(scheme, userInfo, host, port != null ? Integer.parseInt(port) : -1, path, query, fragment).toURL();
            }
            catch (URISyntaxException e) {
                throw new MalformedURLException("Unable to create URL from " + url + ": " + e.getMessage());
            }
        }
        throw new MalformedURLException(url + " is not a valid URL");
    }
}

