/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;

final class DfsBlockMidx
extends DfsBlock {
    private final DfsBlock src;
    private final long midxPackStart;

    DfsBlockMidx(DfsBlock packBlock, long midxPackStart) {
        super(packBlock);
        this.src = packBlock;
        this.midxPackStart = midxPackStart;
    }

    @Override
    int size() {
        return this.src.size();
    }

    @Override
    ByteBuffer zeroCopyByteBuffer(int n) {
        return this.src.zeroCopyByteBuffer(n);
    }

    @Override
    boolean contains(DfsStreamKey want, long pos) {
        return this.src.contains(want, pos - this.midxPackStart);
    }

    @Override
    int copy(long pos, byte[] dstbuf, int dstoff, int cnt) {
        return this.src.copy(pos - this.midxPackStart, dstbuf, dstoff, cnt);
    }

    @Override
    int setInput(long pos, Inflater inf) throws DataFormatException {
        return this.src.setInput(pos - this.midxPackStart, inf);
    }

    @Override
    void crc32(CRC32 out, long pos, int cnt) {
        this.src.crc32(out, pos - this.midxPackStart, cnt);
    }

    @Override
    void write(PackOutputStream out, long pos, int cnt) throws IOException {
        this.src.write(out, pos - this.midxPackStart, cnt);
    }

    @Override
    void check(Inflater inf, byte[] tmp, long pos, int cnt) throws DataFormatException {
        this.src.check(inf, tmp, pos - this.midxPackStart, cnt);
    }
}

