/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.filter;

import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.sheet.XSpreadsheetDocument;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.document.DocumentFamily;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.local.filter.Filter;
import org.jodconverter.local.filter.FilterChain;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.office.utils.Lo;
import org.jodconverter.local.office.utils.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageCounterFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageCounterFilter.class);
    private int pageCount;

    @Override
    public void doFilter(@NonNull OfficeContext context, @NonNull XComponent document, @NonNull FilterChain chain) throws Exception {
        DocumentFamily family = LocalOfficeUtils.getDocumentFamilySilently(document);
        if (family != null) {
            switch (family) {
                case TEXT: 
                case WEB: {
                    LOGGER.debug("Applying the PageCounterFilter for a Text document");
                    this.pageCount = (Integer)Props.getProperty(Lo.qi(XModel.class, document).getCurrentController(), "PageCount");
                    break;
                }
                case SPREADSHEET: {
                    LOGGER.debug("Applying the PageCounterFilter for a Calc document");
                    this.pageCount = Lo.qi(XSpreadsheetDocument.class, document).getSheets().getElementNames().length;
                    break;
                }
                case PRESENTATION: 
                case DRAWING: {
                    LOGGER.debug("Applying the PageCounterFilter for a {} document", (Object)(family == DocumentFamily.DRAWING ? "Draw" : "Impress"));
                    XDrawPages xDrawPages = Lo.qi(XDrawPagesSupplier.class, document).getDrawPages();
                    this.pageCount = xDrawPages.getCount();
                }
            }
        }
        chain.doFilter(context, document);
    }

    public int getPageCount() {
        return this.pageCount;
    }
}

