/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.function;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.security.impl.function.SecuredFunction;
import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class FunctionsImpl {
    private FunctionsImpl() {
    }

    @SerializableByConvention
    static final class ComposedSupplierEx<T, R>
    extends ComposedSecuredFunction<SupplierEx<? extends T>, FunctionEx<? super T, ? extends R>>
    implements SupplierEx<R> {
        ComposedSupplierEx(SupplierEx<? extends T> before, FunctionEx<? super T, ? extends R> after) {
            super(before, after);
        }

        @Override
        public R getEx() throws Exception {
            return ((FunctionEx)this.after).applyEx(((SupplierEx)this.before).getEx());
        }
    }

    @SerializableByConvention
    static final class ComposedConsumerEx<T>
    extends ComposedSecuredFunction<ConsumerEx<? super T>, ConsumerEx<? super T>>
    implements ConsumerEx<T> {
        private static final long serialVersionUID = 1L;

        ComposedConsumerEx(@Nonnull ConsumerEx<? super T> before, @Nonnull ConsumerEx<? super T> after) {
            super(before, after);
        }

        @Override
        public void acceptEx(T t) throws Exception {
            ((ConsumerEx)this.before).acceptEx(t);
            ((ConsumerEx)this.after).acceptEx(t);
        }
    }

    @SerializableByConvention
    static final class ComposedBiFunctionEx<U, V, T, R>
    extends ComposedSecuredFunction<BiFunctionEx<? super U, ? super V, ? extends T>, FunctionEx<? super T, ? extends R>>
    implements BiFunctionEx<U, V, R> {
        private static final long serialVersionUID = 1L;

        ComposedBiFunctionEx(@Nonnull BiFunctionEx<? super U, ? super V, ? extends T> before, @Nonnull FunctionEx<? super T, ? extends R> after) {
            super(before, after);
        }

        @Override
        public R applyEx(U t, V u) throws Exception {
            return ((FunctionEx)this.after).applyEx(((BiFunctionEx)this.before).applyEx(t, u));
        }
    }

    @SerializableByConvention
    static final class ComposedFunctionEx<V, T, R>
    extends ComposedSecuredFunction<FunctionEx<? super V, ? extends T>, FunctionEx<? super T, ? extends R>>
    implements FunctionEx<V, R> {
        private static final long serialVersionUID = 1L;

        ComposedFunctionEx(@Nonnull FunctionEx<? super V, ? extends T> before, @Nonnull FunctionEx<? super T, ? extends R> after) {
            super(before, after);
        }

        @Override
        public R applyEx(V v) throws Exception {
            return ((FunctionEx)this.after).applyEx(((FunctionEx)this.before).applyEx(v));
        }
    }

    @SerializableByConvention
    static class ComposedSecuredFunction<F extends SecuredFunction & Serializable, G extends SecuredFunction & Serializable>
    implements SecuredFunction,
    Serializable {
        protected final F before;
        protected final G after;

        ComposedSecuredFunction(F before, G after) {
            this.before = (SecuredFunction)Objects.requireNonNull(before, "before");
            this.after = (SecuredFunction)Objects.requireNonNull(after, "after");
        }

        @Override
        @Nullable
        public List<Permission> permissions() {
            List<Permission> beforeP = this.before.permissions();
            List<Permission> afterP = this.after.permissions();
            return ComposedSecuredFunction.sumPermissions(afterP, beforeP);
        }

        @Nullable
        private static List<Permission> sumPermissions(@Nullable List<Permission> afterP, @Nullable List<Permission> beforeP) {
            if (afterP == null || afterP.isEmpty()) {
                return beforeP;
            }
            if (beforeP == null || beforeP.isEmpty()) {
                return afterP;
            }
            ArrayList<Permission> permissions = new ArrayList<Permission>(afterP.size() + beforeP.size());
            permissions.addAll(beforeP);
            permissions.addAll(afterP);
            return permissions;
        }
    }
}

