/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.DiagnosticsLog;
import com.hazelcast.internal.diagnostics.DiagnosticsLogWriterImpl;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.logging.ILogger;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

final class DiagnosticsLogger
implements DiagnosticsLog {
    private final Diagnostics diagnostics;
    private final ILogger logger;
    private final ILogger diagnosticsLogger;
    private final DiagnosticsLogWriterImpl logWriter;
    private final CharArrayWriter writer;
    private boolean staticPluginsRendered;

    DiagnosticsLogger(Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
        this.logger = diagnostics.logger;
        this.diagnosticsLogger = diagnostics.loggingService.getLogger("com.hazelcast.diagnostics");
        this.logWriter = new DiagnosticsLogWriterImpl(diagnostics.includeEpochTime, diagnostics.logger);
        this.writer = new CharArrayWriter();
        this.logWriter.init(new PrintWriter(this.writer));
        this.logger.info("Sending diagnostics to the 'com.hazelcast.diagnostics' logger");
    }

    @Override
    public void write(DiagnosticsPlugin plugin) {
        try {
            if (!this.staticPluginsRendered) {
                this.renderStaticPlugins();
                this.staticPluginsRendered = true;
            }
            this.renderPlugin(plugin);
            if (this.writer.size() > 0) {
                String message = this.writer.toString();
                this.diagnosticsLogger.fine(message);
                this.writer.reset();
            }
        }
        catch (RuntimeException e) {
            this.logger.warning("Failed to write to log: ", e);
        }
    }

    private void renderStaticPlugins() {
        for (DiagnosticsPlugin plugin : this.diagnostics.staticTasks.get()) {
            this.renderPlugin(plugin);
        }
    }

    private void renderPlugin(DiagnosticsPlugin plugin) {
        this.logWriter.resetSectionLevel();
        plugin.run(this.logWriter);
    }
}

