/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.everit.json.schema;

import com.hazelcast.shaded.org.everit.json.schema.ConditionalSchema;
import com.hazelcast.shaded.org.everit.json.schema.InternalValidationException;
import com.hazelcast.shaded.org.everit.json.schema.Schema;
import com.hazelcast.shaded.org.everit.json.schema.ValidatingVisitor;
import com.hazelcast.shaded.org.everit.json.schema.ValidationException;
import com.hazelcast.shaded.org.everit.json.schema.Visitor;
import com.hazelcast.shaded.org.everit.json.schema.event.ConditionalSchemaMatchEvent;
import com.hazelcast.shaded.org.everit.json.schema.event.ConditionalSchemaMismatchEvent;
import com.hazelcast.shaded.org.everit.json.schema.event.ConditionalSchemaValidationEvent;
import java.util.Arrays;
import java.util.Objects;

class ConditionalSchemaValidatingVisitor
extends Visitor {
    private final Object subject;
    private final ValidatingVisitor owner;
    private ConditionalSchema conditionalSchema;
    private ValidationException ifSchemaException;

    ConditionalSchemaValidatingVisitor(Object subject, ValidatingVisitor owner) {
        this.subject = subject;
        this.owner = Objects.requireNonNull(owner, "owner cannot be null");
    }

    @Override
    void visitConditionalSchema(ConditionalSchema conditionalSchema) {
        this.conditionalSchema = conditionalSchema;
        if (!conditionalSchema.getIfSchema().isPresent() || !conditionalSchema.getThenSchema().isPresent() && !conditionalSchema.getElseSchema().isPresent()) {
            return;
        }
        super.visitConditionalSchema(conditionalSchema);
    }

    @Override
    void visitIfSchema(Schema ifSchema) {
        if (this.conditionalSchema.getIfSchema().isPresent()) {
            this.ifSchemaException = this.owner.getFailureOfSchema(ifSchema, this.subject);
            if (this.ifSchemaException == null) {
                this.owner.validationListener.ifSchemaMatch(this.createMatchEvent(ConditionalSchemaValidationEvent.Keyword.IF));
            } else {
                this.owner.validationListener.ifSchemaMismatch(this.createMismatchEvent(ConditionalSchemaValidationEvent.Keyword.IF, this.ifSchemaException));
            }
        }
    }

    @Override
    void visitThenSchema(Schema thenSchema) {
        if (this.ifSchemaException == null) {
            ValidationException thenSchemaException = this.owner.getFailureOfSchema(thenSchema, this.subject);
            if (thenSchemaException != null) {
                InternalValidationException failure = new InternalValidationException(this.conditionalSchema, new StringBuilder(new StringBuilder("#")), "input is invalid against the \"then\" schema", Arrays.asList(thenSchemaException), "then", this.conditionalSchema.getSchemaLocation());
                this.owner.validationListener.thenSchemaMismatch(this.createMismatchEvent(ConditionalSchemaValidationEvent.Keyword.THEN, thenSchemaException));
                this.owner.failure(failure);
            } else {
                this.owner.validationListener.thenSchemaMatch(this.createMatchEvent(ConditionalSchemaValidationEvent.Keyword.THEN));
            }
        }
    }

    @Override
    void visitElseSchema(Schema elseSchema) {
        if (this.ifSchemaException != null) {
            ValidationException elseSchemaException = this.owner.getFailureOfSchema(elseSchema, this.subject);
            if (elseSchemaException != null) {
                InternalValidationException failure = new InternalValidationException(this.conditionalSchema, new StringBuilder(new StringBuilder("#")), "input is invalid against both the \"if\" and \"else\" schema", Arrays.asList(this.ifSchemaException, elseSchemaException), "else", this.conditionalSchema.getSchemaLocation());
                this.owner.validationListener.elseSchemaMismatch(this.createMismatchEvent(ConditionalSchemaValidationEvent.Keyword.ELSE, elseSchemaException));
                this.owner.failure(failure);
            } else {
                this.owner.validationListener.elseSchemaMatch(this.createMatchEvent(ConditionalSchemaValidationEvent.Keyword.ELSE));
            }
        }
    }

    private ConditionalSchemaMatchEvent createMatchEvent(ConditionalSchemaValidationEvent.Keyword keyword) {
        return new ConditionalSchemaMatchEvent(this.conditionalSchema, this.subject, keyword);
    }

    private ConditionalSchemaMismatchEvent createMismatchEvent(ConditionalSchemaValidationEvent.Keyword keyword, ValidationException failure) {
        return new ConditionalSchemaMismatchEvent(this.conditionalSchema, this.subject, keyword, failure);
    }
}

