/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal.backwardsCompatibility.bridge;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.asteriskjava.manager.event.BridgeCreateEvent;
import org.asteriskjava.manager.event.BridgeDestroyEvent;
import org.asteriskjava.manager.event.BridgeEnterEvent;
import org.asteriskjava.manager.event.BridgeLeaveEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.internal.backwardsCompatibility.bridge.BridgeState;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class BridgesActive {
    private final Log logger = LogFactory.getLog(BridgesActive.class);
    private final ConcurrentMap<String, BridgeState> activeBridges = new ConcurrentHashMap<String, BridgeState>();

    public ManagerEvent handleEvent(ManagerEvent event) {
        if (event instanceof BridgeCreateEvent) {
            return this.createBridge((BridgeCreateEvent)event);
        }
        if (event instanceof BridgeDestroyEvent) {
            return this.destroyBridge((BridgeDestroyEvent)event);
        }
        if (event instanceof BridgeEnterEvent) {
            return this.enterBridge((BridgeEnterEvent)event);
        }
        if (event instanceof BridgeLeaveEvent) {
            return this.leaveBridge((BridgeLeaveEvent)event);
        }
        return null;
    }

    ManagerEvent createBridge(BridgeCreateEvent event) {
        this.activeBridges.putIfAbsent(event.getBridgeUniqueId(), new BridgeState());
        return null;
    }

    ManagerEvent destroyBridge(BridgeDestroyEvent event) {
        BridgeState state = (BridgeState)this.activeBridges.remove(event.getBridgeUniqueId());
        if (state != null) {
            return state.destroy();
        }
        this.logger.info("Cant find bridge for id " + event.getBridgeUniqueId());
        return null;
    }

    ManagerEvent enterBridge(BridgeEnterEvent event) {
        BridgeState state = (BridgeState)this.activeBridges.get(event.getBridgeUniqueId());
        if (state != null) {
            return state.addMember(event);
        }
        this.logger.error("Cant find bridge for id " + event.getBridgeUniqueId());
        return null;
    }

    ManagerEvent leaveBridge(BridgeLeaveEvent event) {
        BridgeState state = (BridgeState)this.activeBridges.get(event.getBridgeUniqueId());
        if (state != null) {
            return state.removeMember(event);
        }
        this.logger.info("Cant find bridge for id " + event.getBridgeUniqueId());
        return null;
    }
}

