<div align="center">
<a href="https://splidejs.com">
  <img alt="Splide" src="./images/logo.svg" width="70">
</a>

<h1>Splide</h1>

<p>
Splide is a lightweight, flexible and accessible slider and carousel.<br>
No dependencies, no Lighthouse errors.
</p>

[![](https://data.jsdelivr.com/v1/package/npm/@splidejs/splide/badge?v=1)](https://www.jsdelivr.com/package/npm/@splidejs/splide)

<p>
  <a href="https://github.com/Splidejs/splide/releases/latest">Download</a>
  <br>
  <a href="https://splidejs.com/guides/getting-started/">Getting Started</a>
  <br>
  <a href="https://splidejs.com/">Demo</a>
  <br>
  <a href="https://splidejs.com/documents/">Documents</a>
  <br>
  <a href="https://splidejs.com/guides/themes/">Themes</a>
  <br>
  <a href="https://splidejs.com/guides/version4/">About v4</a>
  <br>
  <a href="https://github.com/Splidejs/splide/discussions">Discussions/Q&A</a>
</p>

<h3>
  Ready For
</h3>
<p>
  <a href="https://splidejs.com/guides/getting-started/">
    <img alt="React Splide" src="./images/javascript-logo.svg" width="30">
  </a>
  <a href="https://splidejs.com/guides/getting-started/">
    <img alt="React Splide" src="./images/typescript-logo.svg" width="30">
  </a>
  <a href="https://splidejs.com/integration/react-splide/">
    <img alt="React Splide" src="./images/react-logo.svg" width="30">
  </a>
  <a href="https://splidejs.com/integration/vue-splide/">
    <img alt="Vue Splide" src="./images/vue-logo.svg" width="30">
  </a>
  <a href="https://splidejs.com/integration/svelte-splide/">
    <img alt="Vue Splide" src="./images/svelte-logo.svg" width="30">
  </a>
</p>

<h3>
  Extensions
</h3>

<p>
  <a href="https://splidejs.com/extensions/auto-scroll/">Auto Scroll</a> ・
  <a href="https://splidejs.com/extensions/intersection/">Intersection</a> ・
  <a href="https://splidejs.com/extensions/grid/">Grid</a> ・
  <a href="https://splidejs.com/extensions/video/">Video</a> ・
  <a href="https://splidejs.com/extensions/url-hash/">URL Hash</a>
</p>

<h3>
  Translation
</h3>

<p>
  <a href="https://ja.splidejs.com">日本語</a>
</p>
</div>

## Support Splide

Please support the project if you like it! 
- [GitHub Sponsors](https://github.com/sponsors/NaotoshiFujita)

## Features

- Written in TypeScript
- No dependencies
- Lightweight, 29kB (12kB gzipped)
- Flexible and extensible
- Protected by 400+ test cases
- Multiple slides
- Slide or fade transition by CSS
- Supports breakpoints
- Accepts CSS relative units
- Autoplay with progress bar and a play-pause toggle button
- RTL and vertical direction
- Mouse drag and touch swipe
- Free drag mode
- Mouse wheel navigation
- Nested slider
- Lazy loading
- Thumbnail slider
- Auto width and height
- Accessibility friendly
- Live Region
- Internet Explorer 10


## No Lighthouse Errors

Here is the mobile version result of the [Splide front page](https://splidejs.com):

<img alt="Lighthouse result of the Splide frontpage" src="./images/lighthouse-mobile.png" width="500">

The Splide slider does not degrade Accessibility, Best Practices and SEO 🎉


## License

Splide is released under MIT license. © 2022 Naotoshi Fujita
