/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetAuthenticationFactorFormat is the corresponding interface of BACnetAuthenticationFactorFormat
type BACnetAuthenticationFactorFormat interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetFormatType returns FormatType (property field)
	GetFormatType() BACnetAuthenticationFactorTypeTagged
	// GetVendorId returns VendorId (property field)
	GetVendorId() BACnetVendorIdTagged
	// GetVendorFormat returns VendorFormat (property field)
	GetVendorFormat() BACnetContextTagUnsignedInteger
	// IsBACnetAuthenticationFactorFormat is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetAuthenticationFactorFormat()
	// CreateBuilder creates a BACnetAuthenticationFactorFormatBuilder
	CreateBACnetAuthenticationFactorFormatBuilder() BACnetAuthenticationFactorFormatBuilder
}

// _BACnetAuthenticationFactorFormat is the data-structure of this message
type _BACnetAuthenticationFactorFormat struct {
	FormatType   BACnetAuthenticationFactorTypeTagged
	VendorId     BACnetVendorIdTagged
	VendorFormat BACnetContextTagUnsignedInteger
}

var _ BACnetAuthenticationFactorFormat = (*_BACnetAuthenticationFactorFormat)(nil)

// NewBACnetAuthenticationFactorFormat factory function for _BACnetAuthenticationFactorFormat
func NewBACnetAuthenticationFactorFormat(formatType BACnetAuthenticationFactorTypeTagged, vendorId BACnetVendorIdTagged, vendorFormat BACnetContextTagUnsignedInteger) *_BACnetAuthenticationFactorFormat {
	if formatType == nil {
		panic("formatType of type BACnetAuthenticationFactorTypeTagged for BACnetAuthenticationFactorFormat must not be nil")
	}
	return &_BACnetAuthenticationFactorFormat{FormatType: formatType, VendorId: vendorId, VendorFormat: vendorFormat}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetAuthenticationFactorFormatBuilder is a builder for BACnetAuthenticationFactorFormat
type BACnetAuthenticationFactorFormatBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(formatType BACnetAuthenticationFactorTypeTagged) BACnetAuthenticationFactorFormatBuilder
	// WithFormatType adds FormatType (property field)
	WithFormatType(BACnetAuthenticationFactorTypeTagged) BACnetAuthenticationFactorFormatBuilder
	// WithFormatTypeBuilder adds FormatType (property field) which is build by the builder
	WithFormatTypeBuilder(func(BACnetAuthenticationFactorTypeTaggedBuilder) BACnetAuthenticationFactorTypeTaggedBuilder) BACnetAuthenticationFactorFormatBuilder
	// WithVendorId adds VendorId (property field)
	WithOptionalVendorId(BACnetVendorIdTagged) BACnetAuthenticationFactorFormatBuilder
	// WithOptionalVendorIdBuilder adds VendorId (property field) which is build by the builder
	WithOptionalVendorIdBuilder(func(BACnetVendorIdTaggedBuilder) BACnetVendorIdTaggedBuilder) BACnetAuthenticationFactorFormatBuilder
	// WithVendorFormat adds VendorFormat (property field)
	WithOptionalVendorFormat(BACnetContextTagUnsignedInteger) BACnetAuthenticationFactorFormatBuilder
	// WithOptionalVendorFormatBuilder adds VendorFormat (property field) which is build by the builder
	WithOptionalVendorFormatBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetAuthenticationFactorFormatBuilder
	// Build builds the BACnetAuthenticationFactorFormat or returns an error if something is wrong
	Build() (BACnetAuthenticationFactorFormat, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetAuthenticationFactorFormat
}

// NewBACnetAuthenticationFactorFormatBuilder() creates a BACnetAuthenticationFactorFormatBuilder
func NewBACnetAuthenticationFactorFormatBuilder() BACnetAuthenticationFactorFormatBuilder {
	return &_BACnetAuthenticationFactorFormatBuilder{_BACnetAuthenticationFactorFormat: new(_BACnetAuthenticationFactorFormat)}
}

type _BACnetAuthenticationFactorFormatBuilder struct {
	*_BACnetAuthenticationFactorFormat

	collectedErr []error
}

var _ (BACnetAuthenticationFactorFormatBuilder) = (*_BACnetAuthenticationFactorFormatBuilder)(nil)

func (b *_BACnetAuthenticationFactorFormatBuilder) WithMandatoryFields(formatType BACnetAuthenticationFactorTypeTagged) BACnetAuthenticationFactorFormatBuilder {
	return b.WithFormatType(formatType)
}

func (b *_BACnetAuthenticationFactorFormatBuilder) WithFormatType(formatType BACnetAuthenticationFactorTypeTagged) BACnetAuthenticationFactorFormatBuilder {
	b.FormatType = formatType
	return b
}

func (b *_BACnetAuthenticationFactorFormatBuilder) WithFormatTypeBuilder(builderSupplier func(BACnetAuthenticationFactorTypeTaggedBuilder) BACnetAuthenticationFactorTypeTaggedBuilder) BACnetAuthenticationFactorFormatBuilder {
	builder := builderSupplier(b.FormatType.CreateBACnetAuthenticationFactorTypeTaggedBuilder())
	var err error
	b.FormatType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetAuthenticationFactorTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetAuthenticationFactorFormatBuilder) WithOptionalVendorId(vendorId BACnetVendorIdTagged) BACnetAuthenticationFactorFormatBuilder {
	b.VendorId = vendorId
	return b
}

func (b *_BACnetAuthenticationFactorFormatBuilder) WithOptionalVendorIdBuilder(builderSupplier func(BACnetVendorIdTaggedBuilder) BACnetVendorIdTaggedBuilder) BACnetAuthenticationFactorFormatBuilder {
	builder := builderSupplier(b.VendorId.CreateBACnetVendorIdTaggedBuilder())
	var err error
	b.VendorId, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetVendorIdTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetAuthenticationFactorFormatBuilder) WithOptionalVendorFormat(vendorFormat BACnetContextTagUnsignedInteger) BACnetAuthenticationFactorFormatBuilder {
	b.VendorFormat = vendorFormat
	return b
}

func (b *_BACnetAuthenticationFactorFormatBuilder) WithOptionalVendorFormatBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetAuthenticationFactorFormatBuilder {
	builder := builderSupplier(b.VendorFormat.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.VendorFormat, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetAuthenticationFactorFormatBuilder) Build() (BACnetAuthenticationFactorFormat, error) {
	if b.FormatType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'formatType' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetAuthenticationFactorFormat.deepCopy(), nil
}

func (b *_BACnetAuthenticationFactorFormatBuilder) MustBuild() BACnetAuthenticationFactorFormat {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetAuthenticationFactorFormatBuilder) DeepCopy() any {
	_copy := b.CreateBACnetAuthenticationFactorFormatBuilder().(*_BACnetAuthenticationFactorFormatBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetAuthenticationFactorFormatBuilder creates a BACnetAuthenticationFactorFormatBuilder
func (b *_BACnetAuthenticationFactorFormat) CreateBACnetAuthenticationFactorFormatBuilder() BACnetAuthenticationFactorFormatBuilder {
	if b == nil {
		return NewBACnetAuthenticationFactorFormatBuilder()
	}
	return &_BACnetAuthenticationFactorFormatBuilder{_BACnetAuthenticationFactorFormat: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetAuthenticationFactorFormat) GetFormatType() BACnetAuthenticationFactorTypeTagged {
	return m.FormatType
}

func (m *_BACnetAuthenticationFactorFormat) GetVendorId() BACnetVendorIdTagged {
	return m.VendorId
}

func (m *_BACnetAuthenticationFactorFormat) GetVendorFormat() BACnetContextTagUnsignedInteger {
	return m.VendorFormat
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetAuthenticationFactorFormat(structType any) BACnetAuthenticationFactorFormat {
	if casted, ok := structType.(BACnetAuthenticationFactorFormat); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetAuthenticationFactorFormat); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetAuthenticationFactorFormat) GetTypeName() string {
	return "BACnetAuthenticationFactorFormat"
}

func (m *_BACnetAuthenticationFactorFormat) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (formatType)
	lengthInBits += m.FormatType.GetLengthInBits(ctx)

	// Optional Field (vendorId)
	if m.VendorId != nil {
		lengthInBits += m.VendorId.GetLengthInBits(ctx)
	}

	// Optional Field (vendorFormat)
	if m.VendorFormat != nil {
		lengthInBits += m.VendorFormat.GetLengthInBits(ctx)
	}

	return lengthInBits
}

func (m *_BACnetAuthenticationFactorFormat) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetAuthenticationFactorFormatParse(ctx context.Context, theBytes []byte) (BACnetAuthenticationFactorFormat, error) {
	return BACnetAuthenticationFactorFormatParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetAuthenticationFactorFormatParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAuthenticationFactorFormat, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAuthenticationFactorFormat, error) {
		return BACnetAuthenticationFactorFormatParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetAuthenticationFactorFormatParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAuthenticationFactorFormat, error) {
	v, err := (&_BACnetAuthenticationFactorFormat{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetAuthenticationFactorFormat) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetAuthenticationFactorFormat BACnetAuthenticationFactorFormat, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetAuthenticationFactorFormat"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetAuthenticationFactorFormat")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	formatType, err := ReadSimpleField[BACnetAuthenticationFactorTypeTagged](ctx, "formatType", ReadComplex[BACnetAuthenticationFactorTypeTagged](BACnetAuthenticationFactorTypeTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'formatType' field"))
	}
	m.FormatType = formatType

	var vendorId BACnetVendorIdTagged
	_vendorId, err := ReadOptionalField[BACnetVendorIdTagged](ctx, "vendorId", ReadComplex[BACnetVendorIdTagged](BACnetVendorIdTaggedParseWithBufferProducer((uint8)(uint8(1)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'vendorId' field"))
	}
	if _vendorId != nil {
		vendorId = *_vendorId
		m.VendorId = vendorId
	}

	var vendorFormat BACnetContextTagUnsignedInteger
	_vendorFormat, err := ReadOptionalField[BACnetContextTagUnsignedInteger](ctx, "vendorFormat", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(2)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'vendorFormat' field"))
	}
	if _vendorFormat != nil {
		vendorFormat = *_vendorFormat
		m.VendorFormat = vendorFormat
	}

	if closeErr := readBuffer.CloseContext("BACnetAuthenticationFactorFormat"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetAuthenticationFactorFormat")
	}

	return m, nil
}

func (m *_BACnetAuthenticationFactorFormat) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetAuthenticationFactorFormat) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetAuthenticationFactorFormat"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetAuthenticationFactorFormat")
	}

	if err := WriteSimpleField[BACnetAuthenticationFactorTypeTagged](ctx, "formatType", m.GetFormatType(), WriteComplex[BACnetAuthenticationFactorTypeTagged](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'formatType' field")
	}

	if err := WriteOptionalField[BACnetVendorIdTagged](ctx, "vendorId", GetRef(m.GetVendorId()), WriteComplex[BACnetVendorIdTagged](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'vendorId' field")
	}

	if err := WriteOptionalField[BACnetContextTagUnsignedInteger](ctx, "vendorFormat", GetRef(m.GetVendorFormat()), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'vendorFormat' field")
	}

	if popErr := writeBuffer.PopContext("BACnetAuthenticationFactorFormat"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetAuthenticationFactorFormat")
	}
	return nil
}

func (m *_BACnetAuthenticationFactorFormat) IsBACnetAuthenticationFactorFormat() {}

func (m *_BACnetAuthenticationFactorFormat) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetAuthenticationFactorFormat) deepCopy() *_BACnetAuthenticationFactorFormat {
	if m == nil {
		return nil
	}
	_BACnetAuthenticationFactorFormatCopy := &_BACnetAuthenticationFactorFormat{
		utils.DeepCopy[BACnetAuthenticationFactorTypeTagged](m.FormatType),
		utils.DeepCopy[BACnetVendorIdTagged](m.VendorId),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.VendorFormat),
	}
	return _BACnetAuthenticationFactorFormatCopy
}

func (m *_BACnetAuthenticationFactorFormat) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
