/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataDaysRemaining is the corresponding interface of BACnetConstructedDataDaysRemaining
type BACnetConstructedDataDaysRemaining interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetDaysRemaining returns DaysRemaining (property field)
	GetDaysRemaining() BACnetApplicationTagSignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagSignedInteger
	// IsBACnetConstructedDataDaysRemaining is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataDaysRemaining()
	// CreateBuilder creates a BACnetConstructedDataDaysRemainingBuilder
	CreateBACnetConstructedDataDaysRemainingBuilder() BACnetConstructedDataDaysRemainingBuilder
}

// _BACnetConstructedDataDaysRemaining is the data-structure of this message
type _BACnetConstructedDataDaysRemaining struct {
	BACnetConstructedDataContract
	DaysRemaining BACnetApplicationTagSignedInteger
}

var _ BACnetConstructedDataDaysRemaining = (*_BACnetConstructedDataDaysRemaining)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataDaysRemaining)(nil)

// NewBACnetConstructedDataDaysRemaining factory function for _BACnetConstructedDataDaysRemaining
func NewBACnetConstructedDataDaysRemaining(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, daysRemaining BACnetApplicationTagSignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataDaysRemaining {
	if daysRemaining == nil {
		panic("daysRemaining of type BACnetApplicationTagSignedInteger for BACnetConstructedDataDaysRemaining must not be nil")
	}
	_result := &_BACnetConstructedDataDaysRemaining{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		DaysRemaining:                 daysRemaining,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataDaysRemainingBuilder is a builder for BACnetConstructedDataDaysRemaining
type BACnetConstructedDataDaysRemainingBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(daysRemaining BACnetApplicationTagSignedInteger) BACnetConstructedDataDaysRemainingBuilder
	// WithDaysRemaining adds DaysRemaining (property field)
	WithDaysRemaining(BACnetApplicationTagSignedInteger) BACnetConstructedDataDaysRemainingBuilder
	// WithDaysRemainingBuilder adds DaysRemaining (property field) which is build by the builder
	WithDaysRemainingBuilder(func(BACnetApplicationTagSignedIntegerBuilder) BACnetApplicationTagSignedIntegerBuilder) BACnetConstructedDataDaysRemainingBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataDaysRemaining or returns an error if something is wrong
	Build() (BACnetConstructedDataDaysRemaining, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataDaysRemaining
}

// NewBACnetConstructedDataDaysRemainingBuilder() creates a BACnetConstructedDataDaysRemainingBuilder
func NewBACnetConstructedDataDaysRemainingBuilder() BACnetConstructedDataDaysRemainingBuilder {
	return &_BACnetConstructedDataDaysRemainingBuilder{_BACnetConstructedDataDaysRemaining: new(_BACnetConstructedDataDaysRemaining)}
}

type _BACnetConstructedDataDaysRemainingBuilder struct {
	*_BACnetConstructedDataDaysRemaining

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataDaysRemainingBuilder) = (*_BACnetConstructedDataDaysRemainingBuilder)(nil)

func (b *_BACnetConstructedDataDaysRemainingBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataDaysRemaining
}

func (b *_BACnetConstructedDataDaysRemainingBuilder) WithMandatoryFields(daysRemaining BACnetApplicationTagSignedInteger) BACnetConstructedDataDaysRemainingBuilder {
	return b.WithDaysRemaining(daysRemaining)
}

func (b *_BACnetConstructedDataDaysRemainingBuilder) WithDaysRemaining(daysRemaining BACnetApplicationTagSignedInteger) BACnetConstructedDataDaysRemainingBuilder {
	b.DaysRemaining = daysRemaining
	return b
}

func (b *_BACnetConstructedDataDaysRemainingBuilder) WithDaysRemainingBuilder(builderSupplier func(BACnetApplicationTagSignedIntegerBuilder) BACnetApplicationTagSignedIntegerBuilder) BACnetConstructedDataDaysRemainingBuilder {
	builder := builderSupplier(b.DaysRemaining.CreateBACnetApplicationTagSignedIntegerBuilder())
	var err error
	b.DaysRemaining, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagSignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataDaysRemainingBuilder) Build() (BACnetConstructedDataDaysRemaining, error) {
	if b.DaysRemaining == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'daysRemaining' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataDaysRemaining.deepCopy(), nil
}

func (b *_BACnetConstructedDataDaysRemainingBuilder) MustBuild() BACnetConstructedDataDaysRemaining {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataDaysRemainingBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataDaysRemainingBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataDaysRemainingBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataDaysRemainingBuilder().(*_BACnetConstructedDataDaysRemainingBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataDaysRemainingBuilder creates a BACnetConstructedDataDaysRemainingBuilder
func (b *_BACnetConstructedDataDaysRemaining) CreateBACnetConstructedDataDaysRemainingBuilder() BACnetConstructedDataDaysRemainingBuilder {
	if b == nil {
		return NewBACnetConstructedDataDaysRemainingBuilder()
	}
	return &_BACnetConstructedDataDaysRemainingBuilder{_BACnetConstructedDataDaysRemaining: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataDaysRemaining) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataDaysRemaining) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_DAYS_REMAINING
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataDaysRemaining) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataDaysRemaining) GetDaysRemaining() BACnetApplicationTagSignedInteger {
	return m.DaysRemaining
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataDaysRemaining) GetActualValue() BACnetApplicationTagSignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagSignedInteger(m.GetDaysRemaining())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataDaysRemaining(structType any) BACnetConstructedDataDaysRemaining {
	if casted, ok := structType.(BACnetConstructedDataDaysRemaining); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataDaysRemaining); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataDaysRemaining) GetTypeName() string {
	return "BACnetConstructedDataDaysRemaining"
}

func (m *_BACnetConstructedDataDaysRemaining) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (daysRemaining)
	lengthInBits += m.DaysRemaining.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataDaysRemaining) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataDaysRemaining) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataDaysRemaining BACnetConstructedDataDaysRemaining, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataDaysRemaining"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataDaysRemaining")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	daysRemaining, err := ReadSimpleField[BACnetApplicationTagSignedInteger](ctx, "daysRemaining", ReadComplex[BACnetApplicationTagSignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagSignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'daysRemaining' field"))
	}
	m.DaysRemaining = daysRemaining

	actualValue, err := ReadVirtualField[BACnetApplicationTagSignedInteger](ctx, "actualValue", (*BACnetApplicationTagSignedInteger)(nil), daysRemaining)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataDaysRemaining"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataDaysRemaining")
	}

	return m, nil
}

func (m *_BACnetConstructedDataDaysRemaining) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataDaysRemaining) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataDaysRemaining"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataDaysRemaining")
		}

		if err := WriteSimpleField[BACnetApplicationTagSignedInteger](ctx, "daysRemaining", m.GetDaysRemaining(), WriteComplex[BACnetApplicationTagSignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'daysRemaining' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataDaysRemaining"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataDaysRemaining")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataDaysRemaining) IsBACnetConstructedDataDaysRemaining() {}

func (m *_BACnetConstructedDataDaysRemaining) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataDaysRemaining) deepCopy() *_BACnetConstructedDataDaysRemaining {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataDaysRemainingCopy := &_BACnetConstructedDataDaysRemaining{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagSignedInteger](m.DaysRemaining),
	}
	_BACnetConstructedDataDaysRemainingCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataDaysRemainingCopy
}

func (m *_BACnetConstructedDataDaysRemaining) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
