/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyAccessResultAccessResult is the corresponding interface of BACnetPropertyAccessResultAccessResult
type BACnetPropertyAccessResultAccessResult interface {
	BACnetPropertyAccessResultAccessResultContract
	BACnetPropertyAccessResultAccessResultRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetPropertyAccessResultAccessResult is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyAccessResultAccessResult()
	// CreateBuilder creates a BACnetPropertyAccessResultAccessResultBuilder
	CreateBACnetPropertyAccessResultAccessResultBuilder() BACnetPropertyAccessResultAccessResultBuilder
}

// BACnetPropertyAccessResultAccessResultContract provides a set of functions which can be overwritten by a sub struct
type BACnetPropertyAccessResultAccessResultContract interface {
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// GetObjectTypeArgument() returns a parser argument
	GetObjectTypeArgument() BACnetObjectType
	// GetPropertyIdentifierArgument() returns a parser argument
	GetPropertyIdentifierArgument() BACnetPropertyIdentifier
	// GetPropertyArrayIndexArgument() returns a parser argument
	GetPropertyArrayIndexArgument() BACnetTagPayloadUnsignedInteger
	// IsBACnetPropertyAccessResultAccessResult is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyAccessResultAccessResult()
	// CreateBuilder creates a BACnetPropertyAccessResultAccessResultBuilder
	CreateBACnetPropertyAccessResultAccessResultBuilder() BACnetPropertyAccessResultAccessResultBuilder
}

// BACnetPropertyAccessResultAccessResultRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetPropertyAccessResultAccessResultRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPeekedTagNumber returns PeekedTagNumber (discriminator field)
	GetPeekedTagNumber() uint8
}

// _BACnetPropertyAccessResultAccessResult is the data-structure of this message
type _BACnetPropertyAccessResultAccessResult struct {
	_SubType interface {
		BACnetPropertyAccessResultAccessResultContract
		BACnetPropertyAccessResultAccessResultRequirements
	}
	PeekedTagHeader BACnetTagHeader

	// Arguments.
	ObjectTypeArgument         BACnetObjectType
	PropertyIdentifierArgument BACnetPropertyIdentifier
	PropertyArrayIndexArgument BACnetTagPayloadUnsignedInteger
}

var _ BACnetPropertyAccessResultAccessResultContract = (*_BACnetPropertyAccessResultAccessResult)(nil)

// NewBACnetPropertyAccessResultAccessResult factory function for _BACnetPropertyAccessResultAccessResult
func NewBACnetPropertyAccessResultAccessResult(peekedTagHeader BACnetTagHeader, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, propertyArrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetPropertyAccessResultAccessResult {
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetPropertyAccessResultAccessResult must not be nil")
	}
	return &_BACnetPropertyAccessResultAccessResult{PeekedTagHeader: peekedTagHeader, ObjectTypeArgument: objectTypeArgument, PropertyIdentifierArgument: propertyIdentifierArgument, PropertyArrayIndexArgument: propertyArrayIndexArgument}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyAccessResultAccessResultBuilder is a builder for BACnetPropertyAccessResultAccessResult
type BACnetPropertyAccessResultAccessResultBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetPropertyAccessResultAccessResultBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetPropertyAccessResultAccessResultBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetPropertyAccessResultAccessResultBuilder
	// WithArgObjectTypeArgument sets a parser argument
	WithArgObjectTypeArgument(BACnetObjectType) BACnetPropertyAccessResultAccessResultBuilder
	// WithArgPropertyIdentifierArgument sets a parser argument
	WithArgPropertyIdentifierArgument(BACnetPropertyIdentifier) BACnetPropertyAccessResultAccessResultBuilder
	// WithArgPropertyArrayIndexArgument sets a parser argument
	WithArgPropertyArrayIndexArgument(BACnetTagPayloadUnsignedInteger) BACnetPropertyAccessResultAccessResultBuilder
	// AsBACnetPropertyAccessResultAccessResultPropertyValue converts this build to a subType of BACnetPropertyAccessResultAccessResult. It is always possible to return to current builder using Done()
	AsBACnetPropertyAccessResultAccessResultPropertyValue() BACnetPropertyAccessResultAccessResultPropertyValueBuilder
	// AsBACnetPropertyAccessResultAccessResultPropertyAccessError converts this build to a subType of BACnetPropertyAccessResultAccessResult. It is always possible to return to current builder using Done()
	AsBACnetPropertyAccessResultAccessResultPropertyAccessError() BACnetPropertyAccessResultAccessResultPropertyAccessErrorBuilder
	// Build builds the BACnetPropertyAccessResultAccessResult or returns an error if something is wrong
	PartialBuild() (BACnetPropertyAccessResultAccessResultContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetPropertyAccessResultAccessResultContract
	// Build builds the BACnetPropertyAccessResultAccessResult or returns an error if something is wrong
	Build() (BACnetPropertyAccessResultAccessResult, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyAccessResultAccessResult
}

// NewBACnetPropertyAccessResultAccessResultBuilder() creates a BACnetPropertyAccessResultAccessResultBuilder
func NewBACnetPropertyAccessResultAccessResultBuilder() BACnetPropertyAccessResultAccessResultBuilder {
	return &_BACnetPropertyAccessResultAccessResultBuilder{_BACnetPropertyAccessResultAccessResult: new(_BACnetPropertyAccessResultAccessResult)}
}

type _BACnetPropertyAccessResultAccessResultChildBuilder interface {
	utils.Copyable
	setParent(BACnetPropertyAccessResultAccessResultContract)
	buildForBACnetPropertyAccessResultAccessResult() (BACnetPropertyAccessResultAccessResult, error)
}

type _BACnetPropertyAccessResultAccessResultBuilder struct {
	*_BACnetPropertyAccessResultAccessResult

	childBuilder _BACnetPropertyAccessResultAccessResultChildBuilder

	collectedErr []error
}

var _ (BACnetPropertyAccessResultAccessResultBuilder) = (*_BACnetPropertyAccessResultAccessResultBuilder)(nil)

func (b *_BACnetPropertyAccessResultAccessResultBuilder) WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetPropertyAccessResultAccessResultBuilder {
	return b.WithPeekedTagHeader(peekedTagHeader)
}

func (b *_BACnetPropertyAccessResultAccessResultBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetPropertyAccessResultAccessResultBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetPropertyAccessResultAccessResultBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetPropertyAccessResultAccessResultBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyAccessResultAccessResultBuilder) WithArgObjectTypeArgument(objectTypeArgument BACnetObjectType) BACnetPropertyAccessResultAccessResultBuilder {
	b.ObjectTypeArgument = objectTypeArgument
	return b
}
func (b *_BACnetPropertyAccessResultAccessResultBuilder) WithArgPropertyIdentifierArgument(propertyIdentifierArgument BACnetPropertyIdentifier) BACnetPropertyAccessResultAccessResultBuilder {
	b.PropertyIdentifierArgument = propertyIdentifierArgument
	return b
}
func (b *_BACnetPropertyAccessResultAccessResultBuilder) WithArgPropertyArrayIndexArgument(propertyArrayIndexArgument BACnetTagPayloadUnsignedInteger) BACnetPropertyAccessResultAccessResultBuilder {
	b.PropertyArrayIndexArgument = propertyArrayIndexArgument
	return b
}

func (b *_BACnetPropertyAccessResultAccessResultBuilder) PartialBuild() (BACnetPropertyAccessResultAccessResultContract, error) {
	if b.PeekedTagHeader == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetPropertyAccessResultAccessResult.deepCopy(), nil
}

func (b *_BACnetPropertyAccessResultAccessResultBuilder) PartialMustBuild() BACnetPropertyAccessResultAccessResultContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyAccessResultAccessResultBuilder) AsBACnetPropertyAccessResultAccessResultPropertyValue() BACnetPropertyAccessResultAccessResultPropertyValueBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyAccessResultAccessResultPropertyValueBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyAccessResultAccessResultPropertyValueBuilder().(*_BACnetPropertyAccessResultAccessResultPropertyValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyAccessResultAccessResultBuilder) AsBACnetPropertyAccessResultAccessResultPropertyAccessError() BACnetPropertyAccessResultAccessResultPropertyAccessErrorBuilder {
	if cb, ok := b.childBuilder.(BACnetPropertyAccessResultAccessResultPropertyAccessErrorBuilder); ok {
		return cb
	}
	cb := NewBACnetPropertyAccessResultAccessResultPropertyAccessErrorBuilder().(*_BACnetPropertyAccessResultAccessResultPropertyAccessErrorBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetPropertyAccessResultAccessResultBuilder) Build() (BACnetPropertyAccessResultAccessResult, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetPropertyAccessResultAccessResult()
}

func (b *_BACnetPropertyAccessResultAccessResultBuilder) MustBuild() BACnetPropertyAccessResultAccessResult {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyAccessResultAccessResultBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyAccessResultAccessResultBuilder().(*_BACnetPropertyAccessResultAccessResultBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetPropertyAccessResultAccessResultChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetPropertyAccessResultAccessResultBuilder creates a BACnetPropertyAccessResultAccessResultBuilder
func (b *_BACnetPropertyAccessResultAccessResult) CreateBACnetPropertyAccessResultAccessResultBuilder() BACnetPropertyAccessResultAccessResultBuilder {
	if b == nil {
		return NewBACnetPropertyAccessResultAccessResultBuilder()
	}
	return &_BACnetPropertyAccessResultAccessResultBuilder{_BACnetPropertyAccessResultAccessResult: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyAccessResultAccessResult) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetPropertyAccessResultAccessResult) GetPeekedTagNumber() uint8 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyAccessResultAccessResult(structType any) BACnetPropertyAccessResultAccessResult {
	if casted, ok := structType.(BACnetPropertyAccessResultAccessResult); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyAccessResultAccessResult); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyAccessResultAccessResult) GetTypeName() string {
	return "BACnetPropertyAccessResultAccessResult"
}

func (m *_BACnetPropertyAccessResultAccessResult) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetPropertyAccessResultAccessResult) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetPropertyAccessResultAccessResult) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetPropertyAccessResultAccessResultParse[T BACnetPropertyAccessResultAccessResult](ctx context.Context, theBytes []byte, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, propertyArrayIndexArgument BACnetTagPayloadUnsignedInteger) (T, error) {
	return BACnetPropertyAccessResultAccessResultParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), objectTypeArgument, propertyIdentifierArgument, propertyArrayIndexArgument)
}

func BACnetPropertyAccessResultAccessResultParseWithBufferProducer[T BACnetPropertyAccessResultAccessResult](objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, propertyArrayIndexArgument BACnetTagPayloadUnsignedInteger) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetPropertyAccessResultAccessResultParseWithBuffer[T](ctx, readBuffer, objectTypeArgument, propertyIdentifierArgument, propertyArrayIndexArgument)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetPropertyAccessResultAccessResultParseWithBuffer[T BACnetPropertyAccessResultAccessResult](ctx context.Context, readBuffer utils.ReadBuffer, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, propertyArrayIndexArgument BACnetTagPayloadUnsignedInteger) (T, error) {
	v, err := (&_BACnetPropertyAccessResultAccessResult{ObjectTypeArgument: objectTypeArgument, PropertyIdentifierArgument: propertyIdentifierArgument, PropertyArrayIndexArgument: propertyArrayIndexArgument}).parse(ctx, readBuffer, objectTypeArgument, propertyIdentifierArgument, propertyArrayIndexArgument)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetPropertyAccessResultAccessResult) parse(ctx context.Context, readBuffer utils.ReadBuffer, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, propertyArrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetPropertyAccessResultAccessResult BACnetPropertyAccessResultAccessResult, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyAccessResultAccessResult"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyAccessResultAccessResult")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetPropertyAccessResultAccessResult
	switch {
	case peekedTagNumber == uint8(4): // BACnetPropertyAccessResultAccessResultPropertyValue
		if _child, err = new(_BACnetPropertyAccessResultAccessResultPropertyValue).parse(ctx, readBuffer, m, objectTypeArgument, propertyIdentifierArgument, propertyArrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyAccessResultAccessResultPropertyValue for type-switch of BACnetPropertyAccessResultAccessResult")
		}
	case peekedTagNumber == uint8(5): // BACnetPropertyAccessResultAccessResultPropertyAccessError
		if _child, err = new(_BACnetPropertyAccessResultAccessResultPropertyAccessError).parse(ctx, readBuffer, m, objectTypeArgument, propertyIdentifierArgument, propertyArrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetPropertyAccessResultAccessResultPropertyAccessError for type-switch of BACnetPropertyAccessResultAccessResult")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [peekedTagNumber=%v]", peekedTagNumber)
	}

	if closeErr := readBuffer.CloseContext("BACnetPropertyAccessResultAccessResult"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyAccessResultAccessResult")
	}

	return _child, nil
}

func (pm *_BACnetPropertyAccessResultAccessResult) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetPropertyAccessResultAccessResult, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetPropertyAccessResultAccessResult"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetPropertyAccessResultAccessResult")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetPropertyAccessResultAccessResult"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetPropertyAccessResultAccessResult")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetPropertyAccessResultAccessResult) GetObjectTypeArgument() BACnetObjectType {
	return m.ObjectTypeArgument
}
func (m *_BACnetPropertyAccessResultAccessResult) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return m.PropertyIdentifierArgument
}
func (m *_BACnetPropertyAccessResultAccessResult) GetPropertyArrayIndexArgument() BACnetTagPayloadUnsignedInteger {
	return m.PropertyArrayIndexArgument
}

//
////

func (m *_BACnetPropertyAccessResultAccessResult) IsBACnetPropertyAccessResultAccessResult() {}

func (m *_BACnetPropertyAccessResultAccessResult) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyAccessResultAccessResult) deepCopy() *_BACnetPropertyAccessResultAccessResult {
	if m == nil {
		return nil
	}
	_BACnetPropertyAccessResultAccessResultCopy := &_BACnetPropertyAccessResultAccessResult{
		nil, // will be set by child
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
		m.ObjectTypeArgument,
		m.PropertyIdentifierArgument,
		m.PropertyArrayIndexArgument,
	}
	return _BACnetPropertyAccessResultAccessResultCopy
}
