/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetServiceAckGetEventInformation is the corresponding interface of BACnetServiceAckGetEventInformation
type BACnetServiceAckGetEventInformation interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetServiceAck
	// GetListOfEventSummaries returns ListOfEventSummaries (property field)
	GetListOfEventSummaries() BACnetEventSummariesList
	// GetMoreEvents returns MoreEvents (property field)
	GetMoreEvents() BACnetContextTagBoolean
	// IsBACnetServiceAckGetEventInformation is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetServiceAckGetEventInformation()
	// CreateBuilder creates a BACnetServiceAckGetEventInformationBuilder
	CreateBACnetServiceAckGetEventInformationBuilder() BACnetServiceAckGetEventInformationBuilder
}

// _BACnetServiceAckGetEventInformation is the data-structure of this message
type _BACnetServiceAckGetEventInformation struct {
	BACnetServiceAckContract
	ListOfEventSummaries BACnetEventSummariesList
	MoreEvents           BACnetContextTagBoolean
}

var _ BACnetServiceAckGetEventInformation = (*_BACnetServiceAckGetEventInformation)(nil)
var _ BACnetServiceAckRequirements = (*_BACnetServiceAckGetEventInformation)(nil)

// NewBACnetServiceAckGetEventInformation factory function for _BACnetServiceAckGetEventInformation
func NewBACnetServiceAckGetEventInformation(listOfEventSummaries BACnetEventSummariesList, moreEvents BACnetContextTagBoolean, serviceAckLength uint32) *_BACnetServiceAckGetEventInformation {
	if listOfEventSummaries == nil {
		panic("listOfEventSummaries of type BACnetEventSummariesList for BACnetServiceAckGetEventInformation must not be nil")
	}
	if moreEvents == nil {
		panic("moreEvents of type BACnetContextTagBoolean for BACnetServiceAckGetEventInformation must not be nil")
	}
	_result := &_BACnetServiceAckGetEventInformation{
		BACnetServiceAckContract: NewBACnetServiceAck(serviceAckLength),
		ListOfEventSummaries:     listOfEventSummaries,
		MoreEvents:               moreEvents,
	}
	_result.BACnetServiceAckContract.(*_BACnetServiceAck)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetServiceAckGetEventInformationBuilder is a builder for BACnetServiceAckGetEventInformation
type BACnetServiceAckGetEventInformationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(listOfEventSummaries BACnetEventSummariesList, moreEvents BACnetContextTagBoolean) BACnetServiceAckGetEventInformationBuilder
	// WithListOfEventSummaries adds ListOfEventSummaries (property field)
	WithListOfEventSummaries(BACnetEventSummariesList) BACnetServiceAckGetEventInformationBuilder
	// WithListOfEventSummariesBuilder adds ListOfEventSummaries (property field) which is build by the builder
	WithListOfEventSummariesBuilder(func(BACnetEventSummariesListBuilder) BACnetEventSummariesListBuilder) BACnetServiceAckGetEventInformationBuilder
	// WithMoreEvents adds MoreEvents (property field)
	WithMoreEvents(BACnetContextTagBoolean) BACnetServiceAckGetEventInformationBuilder
	// WithMoreEventsBuilder adds MoreEvents (property field) which is build by the builder
	WithMoreEventsBuilder(func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetServiceAckGetEventInformationBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetServiceAckBuilder
	// Build builds the BACnetServiceAckGetEventInformation or returns an error if something is wrong
	Build() (BACnetServiceAckGetEventInformation, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetServiceAckGetEventInformation
}

// NewBACnetServiceAckGetEventInformationBuilder() creates a BACnetServiceAckGetEventInformationBuilder
func NewBACnetServiceAckGetEventInformationBuilder() BACnetServiceAckGetEventInformationBuilder {
	return &_BACnetServiceAckGetEventInformationBuilder{_BACnetServiceAckGetEventInformation: new(_BACnetServiceAckGetEventInformation)}
}

type _BACnetServiceAckGetEventInformationBuilder struct {
	*_BACnetServiceAckGetEventInformation

	parentBuilder *_BACnetServiceAckBuilder

	collectedErr []error
}

var _ (BACnetServiceAckGetEventInformationBuilder) = (*_BACnetServiceAckGetEventInformationBuilder)(nil)

func (b *_BACnetServiceAckGetEventInformationBuilder) setParent(contract BACnetServiceAckContract) {
	b.BACnetServiceAckContract = contract
	contract.(*_BACnetServiceAck)._SubType = b._BACnetServiceAckGetEventInformation
}

func (b *_BACnetServiceAckGetEventInformationBuilder) WithMandatoryFields(listOfEventSummaries BACnetEventSummariesList, moreEvents BACnetContextTagBoolean) BACnetServiceAckGetEventInformationBuilder {
	return b.WithListOfEventSummaries(listOfEventSummaries).WithMoreEvents(moreEvents)
}

func (b *_BACnetServiceAckGetEventInformationBuilder) WithListOfEventSummaries(listOfEventSummaries BACnetEventSummariesList) BACnetServiceAckGetEventInformationBuilder {
	b.ListOfEventSummaries = listOfEventSummaries
	return b
}

func (b *_BACnetServiceAckGetEventInformationBuilder) WithListOfEventSummariesBuilder(builderSupplier func(BACnetEventSummariesListBuilder) BACnetEventSummariesListBuilder) BACnetServiceAckGetEventInformationBuilder {
	builder := builderSupplier(b.ListOfEventSummaries.CreateBACnetEventSummariesListBuilder())
	var err error
	b.ListOfEventSummaries, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetEventSummariesListBuilder failed"))
	}
	return b
}

func (b *_BACnetServiceAckGetEventInformationBuilder) WithMoreEvents(moreEvents BACnetContextTagBoolean) BACnetServiceAckGetEventInformationBuilder {
	b.MoreEvents = moreEvents
	return b
}

func (b *_BACnetServiceAckGetEventInformationBuilder) WithMoreEventsBuilder(builderSupplier func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetServiceAckGetEventInformationBuilder {
	builder := builderSupplier(b.MoreEvents.CreateBACnetContextTagBooleanBuilder())
	var err error
	b.MoreEvents, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetServiceAckGetEventInformationBuilder) Build() (BACnetServiceAckGetEventInformation, error) {
	if b.ListOfEventSummaries == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'listOfEventSummaries' not set"))
	}
	if b.MoreEvents == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'moreEvents' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetServiceAckGetEventInformation.deepCopy(), nil
}

func (b *_BACnetServiceAckGetEventInformationBuilder) MustBuild() BACnetServiceAckGetEventInformation {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetServiceAckGetEventInformationBuilder) Done() BACnetServiceAckBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetServiceAckBuilder().(*_BACnetServiceAckBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetServiceAckGetEventInformationBuilder) buildForBACnetServiceAck() (BACnetServiceAck, error) {
	return b.Build()
}

func (b *_BACnetServiceAckGetEventInformationBuilder) DeepCopy() any {
	_copy := b.CreateBACnetServiceAckGetEventInformationBuilder().(*_BACnetServiceAckGetEventInformationBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetServiceAckGetEventInformationBuilder creates a BACnetServiceAckGetEventInformationBuilder
func (b *_BACnetServiceAckGetEventInformation) CreateBACnetServiceAckGetEventInformationBuilder() BACnetServiceAckGetEventInformationBuilder {
	if b == nil {
		return NewBACnetServiceAckGetEventInformationBuilder()
	}
	return &_BACnetServiceAckGetEventInformationBuilder{_BACnetServiceAckGetEventInformation: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetServiceAckGetEventInformation) GetServiceChoice() BACnetConfirmedServiceChoice {
	return BACnetConfirmedServiceChoice_GET_EVENT_INFORMATION
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetServiceAckGetEventInformation) GetParent() BACnetServiceAckContract {
	return m.BACnetServiceAckContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetServiceAckGetEventInformation) GetListOfEventSummaries() BACnetEventSummariesList {
	return m.ListOfEventSummaries
}

func (m *_BACnetServiceAckGetEventInformation) GetMoreEvents() BACnetContextTagBoolean {
	return m.MoreEvents
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetServiceAckGetEventInformation(structType any) BACnetServiceAckGetEventInformation {
	if casted, ok := structType.(BACnetServiceAckGetEventInformation); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetServiceAckGetEventInformation); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetServiceAckGetEventInformation) GetTypeName() string {
	return "BACnetServiceAckGetEventInformation"
}

func (m *_BACnetServiceAckGetEventInformation) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetServiceAckContract.(*_BACnetServiceAck).getLengthInBits(ctx))

	// Simple field (listOfEventSummaries)
	lengthInBits += m.ListOfEventSummaries.GetLengthInBits(ctx)

	// Simple field (moreEvents)
	lengthInBits += m.MoreEvents.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetServiceAckGetEventInformation) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetServiceAckGetEventInformation) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetServiceAck, serviceAckLength uint32) (__bACnetServiceAckGetEventInformation BACnetServiceAckGetEventInformation, err error) {
	m.BACnetServiceAckContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetServiceAckGetEventInformation"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetServiceAckGetEventInformation")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	listOfEventSummaries, err := ReadSimpleField[BACnetEventSummariesList](ctx, "listOfEventSummaries", ReadComplex[BACnetEventSummariesList](BACnetEventSummariesListParseWithBufferProducer((uint8)(uint8(0))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'listOfEventSummaries' field"))
	}
	m.ListOfEventSummaries = listOfEventSummaries

	moreEvents, err := ReadSimpleField[BACnetContextTagBoolean](ctx, "moreEvents", ReadComplex[BACnetContextTagBoolean](BACnetContextTagParseWithBufferProducer[BACnetContextTagBoolean]((uint8)(uint8(1)), (BACnetDataType)(BACnetDataType_BOOLEAN)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'moreEvents' field"))
	}
	m.MoreEvents = moreEvents

	if closeErr := readBuffer.CloseContext("BACnetServiceAckGetEventInformation"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetServiceAckGetEventInformation")
	}

	return m, nil
}

func (m *_BACnetServiceAckGetEventInformation) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetServiceAckGetEventInformation) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetServiceAckGetEventInformation"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetServiceAckGetEventInformation")
		}

		if err := WriteSimpleField[BACnetEventSummariesList](ctx, "listOfEventSummaries", m.GetListOfEventSummaries(), WriteComplex[BACnetEventSummariesList](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'listOfEventSummaries' field")
		}

		if err := WriteSimpleField[BACnetContextTagBoolean](ctx, "moreEvents", m.GetMoreEvents(), WriteComplex[BACnetContextTagBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'moreEvents' field")
		}

		if popErr := writeBuffer.PopContext("BACnetServiceAckGetEventInformation"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetServiceAckGetEventInformation")
		}
		return nil
	}
	return m.BACnetServiceAckContract.(*_BACnetServiceAck).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetServiceAckGetEventInformation) IsBACnetServiceAckGetEventInformation() {}

func (m *_BACnetServiceAckGetEventInformation) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetServiceAckGetEventInformation) deepCopy() *_BACnetServiceAckGetEventInformation {
	if m == nil {
		return nil
	}
	_BACnetServiceAckGetEventInformationCopy := &_BACnetServiceAckGetEventInformation{
		m.BACnetServiceAckContract.(*_BACnetServiceAck).deepCopy(),
		utils.DeepCopy[BACnetEventSummariesList](m.ListOfEventSummaries),
		utils.DeepCopy[BACnetContextTagBoolean](m.MoreEvents),
	}
	_BACnetServiceAckGetEventInformationCopy.BACnetServiceAckContract.(*_BACnetServiceAck)._SubType = m
	return _BACnetServiceAckGetEventInformationCopy
}

func (m *_BACnetServiceAckGetEventInformation) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
