/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnIoCm_DataUnitDataObject implements Message {

  // Properties.
  protected final byte[] dataState;
  protected final PnIoCm_DataUnitIoCs iops;

  // Arguments.
  protected final Integer dataObjectLength;

  public PnIoCm_DataUnitDataObject(
      byte[] dataState, PnIoCm_DataUnitIoCs iops, Integer dataObjectLength) {
    super();
    this.dataState = dataState;
    this.iops = iops;
    this.dataObjectLength = dataObjectLength;
  }

  public byte[] getDataState() {
    return dataState;
  }

  public PnIoCm_DataUnitIoCs getIops() {
    return iops;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnIoCm_DataUnitDataObject");

    // Array Field (dataState)
    writeByteArrayField(
        "dataState",
        dataState,
        writeByteArray(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (iops)
    writeSimpleField(
        "iops", iops, writeComplex(writeBuffer), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnIoCm_DataUnitDataObject");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    PnIoCm_DataUnitDataObject _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Array field
    if (dataState != null) {
      lengthInBits += 8 * dataState.length;
    }

    // Simple field (iops)
    lengthInBits += iops.getLengthInBits();

    return lengthInBits;
  }

  public static PnIoCm_DataUnitDataObject staticParse(
      ReadBuffer readBuffer, Integer dataObjectLength) throws ParseException {
    readBuffer.pullContext("PnIoCm_DataUnitDataObject");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte[] dataState =
        readBuffer.readByteArray(
            "dataState",
            Math.toIntExact(dataObjectLength),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    PnIoCm_DataUnitIoCs iops =
        readSimpleField(
            "iops",
            readComplex(() -> PnIoCm_DataUnitIoCs.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnIoCm_DataUnitDataObject");
    // Create the instance
    PnIoCm_DataUnitDataObject _pnIoCm_DataUnitDataObject;
    _pnIoCm_DataUnitDataObject = new PnIoCm_DataUnitDataObject(dataState, iops, dataObjectLength);
    return _pnIoCm_DataUnitDataObject;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnIoCm_DataUnitDataObject)) {
      return false;
    }
    PnIoCm_DataUnitDataObject that = (PnIoCm_DataUnitDataObject) o;
    return (getDataState() == that.getDataState()) && (getIops() == that.getIops()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getDataState(), getIops());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
