/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.pollinterval;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.awaitility.core.DurationFactory;
import org.awaitility.pollinterval.PollInterval;

public class FibonacciPollInterval
implements PollInterval {
    private static final int DEFAULT_OFFSET = 0;
    private final TimeUnit unit;
    private final int offset;

    public FibonacciPollInterval() {
        this(TimeUnit.MILLISECONDS);
    }

    public FibonacciPollInterval(TimeUnit unit) {
        this(0, unit);
    }

    public FibonacciPollInterval(int offset, TimeUnit unit) {
        if (offset <= -1) {
            throw new IllegalArgumentException("Offset must be greater than or equal to -1");
        }
        if (unit == null) {
            throw new IllegalArgumentException("Chrono unit cannot be null");
        }
        this.offset = offset;
        this.unit = unit;
    }

    @Override
    public Duration next(int pollCount, Duration previousDuration) {
        return DurationFactory.of(this.fibonacci(this.offset + pollCount), this.unit);
    }

    public static FibonacciPollInterval fibonacci() {
        return new FibonacciPollInterval();
    }

    public static FibonacciPollInterval fibonacci(TimeUnit unit) {
        return new FibonacciPollInterval(unit);
    }

    public static FibonacciPollInterval fibonacci(int offset, TimeUnit unit) {
        return new FibonacciPollInterval(offset, unit);
    }

    public FibonacciPollInterval with() {
        return this;
    }

    public FibonacciPollInterval and() {
        return this;
    }

    public FibonacciPollInterval unit(TimeUnit unit) {
        return new FibonacciPollInterval(this.offset, unit);
    }

    public FibonacciPollInterval offset(int offset) {
        return new FibonacciPollInterval(offset, this.unit);
    }

    protected int fibonacci(int value) {
        return this.fib(value, 1, 0);
    }

    private int fib(int value, int current, int previous) {
        if (value == 0) {
            return previous;
        }
        if (value == 1) {
            return current;
        }
        return this.fib(value - 1, current + previous, current);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FibonacciPollInterval)) {
            return false;
        }
        FibonacciPollInterval that = (FibonacciPollInterval)o;
        return this.offset == that.offset && this.unit == that.unit;
    }

    public int hashCode() {
        int result = this.unit.hashCode();
        result = 31 * result + this.offset;
        return result;
    }

    public String toString() {
        return "FibonacciPollInterval{offset=" + this.offset + ", unit=" + (Object)((Object)this.unit) + '}';
    }
}

