/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.file;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.file.FlatAppendFile;
import org.apache.rocketmq.tieredstore.provider.FileSegment;
import org.apache.rocketmq.tieredstore.provider.FileSegmentFactory;
import org.apache.rocketmq.tieredstore.util.MessageFormatUtil;

public class FlatCommitLogFile
extends FlatAppendFile {
    private static final long GET_OFFSET_ERROR = -1L;
    private final AtomicLong firstOffset = new AtomicLong(-1L);

    public FlatCommitLogFile(FileSegmentFactory fileSegmentFactory, String filePath) {
        super(fileSegmentFactory, FileSegmentType.COMMIT_LOG, filePath);
        this.initOffset(0L);
    }

    public boolean tryRollingFile(long interval) {
        FileSegment fileSegment = this.getFileToWrite();
        long timestamp = fileSegment.getMinTimestamp();
        if (timestamp != Long.MAX_VALUE && timestamp + interval < System.currentTimeMillis() && fileSegment.getAppendPosition() >= (long)this.fileSegmentFactory.getStoreConfig().getCommitLogRollingMinimumSize()) {
            this.rollingNewFile(this.getAppendOffset());
            return true;
        }
        return false;
    }

    public long getMinOffsetFromFile() {
        return this.firstOffset.get() == -1L ? this.getMinOffsetFromFileAsync().join().longValue() : this.firstOffset.get();
    }

    public CompletableFuture<Long> getMinOffsetFromFileAsync() {
        int length = 28;
        if (this.fileSegmentTable.isEmpty() || this.getCommitOffset() - this.getMinOffset() < (long)length) {
            return CompletableFuture.completedFuture(-1L);
        }
        return this.readAsync(this.getMinOffset(), length).thenApply(buffer -> {
            this.firstOffset.set(MessageFormatUtil.getQueueOffset(buffer));
            return this.firstOffset.get();
        });
    }

    @Override
    public void destroyExpiredFile(long expireTimestamp) {
        long beforeOffset = this.getMinOffset();
        super.destroyExpiredFile(expireTimestamp);
        long afterOffset = this.getMinOffset();
        if (beforeOffset != afterOffset && afterOffset > 0L) {
            log.info("CommitLog min cq offset reset, filePath={}, offset={}, expireTimestamp={}, change={}-{}", new Object[]{this.filePath, this.firstOffset.get(), expireTimestamp, beforeOffset, afterOffset});
            this.firstOffset.set(-1L);
        }
    }
}

