/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.meter;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.servicecomb.foundation.metrics.meter.LatencyScopeConfig;

public class LatencyScopeMeter {
    private final Id scopeId;
    private final LongAdder times = new LongAdder();
    private long lastTimes = 0L;
    private final long nanoMin;
    private final long nanoMax;

    public LatencyScopeMeter(Id latencyDistributionId, LatencyScopeConfig config) {
        this.nanoMin = TimeUnit.MILLISECONDS.toNanos(config.getMsMin());
        this.nanoMax = TimeUnit.MILLISECONDS.toNanos(config.getMsMax());
        this.scopeId = latencyDistributionId.withTag("scope", String.format("[%d,%s)", config.getMsMin(), config.getMsMax() == Long.MAX_VALUE ? "" : Long.valueOf(config.getMsMax())));
    }

    public boolean update(long nanoLatency) {
        if (this.nanoMin <= nanoLatency && this.nanoMax > nanoLatency) {
            this.times.increment();
            return true;
        }
        return false;
    }

    public Measurement createMeasurement(long msNow) {
        long currentTimes = this.times.longValue();
        long deltaTimes = currentTimes - this.lastTimes;
        this.lastTimes = currentTimes;
        return new Measurement(this.scopeId, msNow, (double)deltaTimes);
    }
}

