/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl.bools;

import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractPrimitiveWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedPrimitiveWriteSchemas;

public class BoolNotPackedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        return RepeatedPrimitiveWriteSchemas.create(protoField, propertyDescriptor, new BoolNotPackedWriters(protoField));
    }

    private static class BoolNotPackedWriters
    extends AbstractPrimitiveWriters<boolean[], Boolean> {
        public BoolNotPackedWriters(Field protoField) {
            super(protoField);
            this.primitiveArrayWriter = (output, array) -> {
                for (boolean element : array) {
                    output.writeBool(this.tag, this.tagSize, element);
                }
            };
            this.arrayWriter = (output, array) -> {
                for (Boolean element : array) {
                    if (element != null) {
                        output.writeBool(this.tag, this.tagSize, element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
            this.collectionWriter = (output, collection) -> {
                for (Boolean element : collection) {
                    if (element != null) {
                        output.writeBool(this.tag, this.tagSize, element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
            this.stringArrayWriter = (output, array) -> {
                for (String element : array) {
                    if (element != null) {
                        boolean parsedValue = Boolean.parseBoolean(element);
                        output.writeBool(this.tag, this.tagSize, parsedValue);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
        }
    }
}

