/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.landsat;

import java.nio.file.Path;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.metadata.iso.content.DefaultImageDescription;
import org.apache.sis.metadata.iso.content.DefaultSampleDimension;
import org.apache.sis.storage.DataOptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.GridResourceWrapper;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.storage.landsat.BandName;
import org.apache.sis.storage.landsat.LandsatStore;
import org.apache.sis.storage.modifier.CoverageModifier;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.identification.Identification;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;

final class Band
extends GridResourceWrapper
implements CoverageModifier {
    private final LandsatStore parent;
    final BandName band;
    LocalName identifier;
    String filename;
    final DefaultSampleDimension sampleDimension;

    Band(LandsatStore parent, BandName band) {
        this.parent = parent;
        this.band = band;
        if (band.wavelength != 0) {
            DefaultBand b = new DefaultBand();
            b.setPeakResponse(Double.valueOf(band.wavelength));
            b.setBoundUnits(Units.NANOMETRE);
            this.sampleDimension = b;
        } else {
            this.sampleDimension = new DefaultSampleDimension();
        }
        this.sampleDimension.setDescription(band.title);
    }

    protected final Object getSynchronizationLock() {
        return this.parent;
    }

    protected GridCoverageResource createSource() throws DataStoreException {
        StorageConnector connector = new StorageConnector((Object)this.getDataPath());
        connector.setOption(DataOptionKey.COVERAGE_MODIFIER, (Object)this);
        return (GridCoverageResource)new GeoTiffStore((DataStore)this.parent, this.parent.getProvider(), connector, true).components().get(0);
    }

    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.of(this.identifier);
    }

    private static boolean isMain(CoverageModifier.Source source) {
        return source.getCoverageIndex().orElse(-1) == 0;
    }

    public GenericName customize(CoverageModifier.Source source, GenericName fallback) {
        return Band.isMain(source) ? this.identifier : fallback;
    }

    public Metadata customize(CoverageModifier.Source source, DefaultMetadata metadata) {
        if (Band.isMain(source)) {
            for (Identification id : metadata.getIdentificationInfo()) {
                DefaultCitation c = (DefaultCitation)id.getCitation();
                if (c == null) continue;
                c.setTitle(this.band.title);
                break;
            }
            DefaultImageDescription content = (DefaultImageDescription)CollectionsExt.first((Iterable)metadata.getContentInfo());
            DefaultAttributeGroup group = (DefaultAttributeGroup)CollectionsExt.first((Iterable)content.getAttributeGroups());
            DefaultSampleDimension sd = (DefaultSampleDimension)CollectionsExt.first((Iterable)group.getAttributes());
            group.getContentTypes().add(CoverageContentType.PHYSICAL_MEASUREMENT);
            sd.setDescription(this.sampleDimension.getDescription());
            sd.setMinValue(this.sampleDimension.getMinValue());
            sd.setMaxValue(this.sampleDimension.getMaxValue());
            sd.setScaleFactor(this.sampleDimension.getScaleFactor());
            sd.setOffset(this.sampleDimension.getOffset());
            sd.setUnits(this.sampleDimension.getUnits());
            if (this.sampleDimension instanceof DefaultBand) {
                DefaultBand s = (DefaultBand)this.sampleDimension;
                DefaultBand t = (DefaultBand)sd;
                t.setPeakResponse(s.getPeakResponse());
                t.setBoundUnits(s.getBoundUnits());
            }
        }
        return metadata;
    }

    public SampleDimension customize(CoverageModifier.BandSource source, SampleDimension.Builder dimension) {
        if (Band.isMain((CoverageModifier.Source)source) && source.getBandIndex() == 0) {
            dimension.setName((GenericName)this.identifier);
            dimension.categories().clear();
            source.getSampleRange().ifPresent(sampleRange -> {
                Number min = (Number)((Object)sampleRange.getMinValue());
                Number max = (Number)((Object)sampleRange.getMaxValue());
                Double scale = this.sampleDimension.getScaleFactor();
                Double offset = this.sampleDimension.getOffset();
                if (min != null && max != null && scale != null && offset != null) {
                    int lower = min.intValue();
                    if (lower >= 0) {
                        dimension.addQualitative(null, 0);
                        if (lower == 0) {
                            lower = 1;
                        }
                    }
                    dimension.addQuantitative((CharSequence)this.band.group.measurement, lower, max.intValue(), scale.doubleValue(), offset.doubleValue(), this.sampleDimension.getUnits());
                }
            });
        }
        return dimension.build();
    }

    public boolean isElectromagneticMeasurement(CoverageModifier.Source source) {
        return Band.isMain(source) && this.band.wavelength != 0;
    }

    public Optional<Resource.FileSet> getFileSet() throws DataStoreException {
        return Optional.of(new Resource.FileSet(this.getDataPath()));
    }

    private Path getDataPath() {
        if (this.parent.directory != null) {
            return this.parent.directory.resolve(this.filename);
        }
        return Path.of(this.filename, new String[0]);
    }
}

