/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.spatial.GCP;

@XmlType(name="MI_GCP_Type", propOrder={"accuracyReports"})
@XmlRootElement(name="MI_GCP")
public class DefaultGCP
extends ISOMetadata
implements GCP {
    private static final long serialVersionUID = -2021981491910341192L;
    private DirectPosition geographicCoordinates;
    private Collection<Element> accuracyReports;

    public DefaultGCP() {
    }

    public DefaultGCP(GCP object) {
        super(object);
        if (object != null) {
            this.accuracyReports = DefaultGCP.copyCollection(object.getAccuracyReports(), Element.class);
            this.geographicCoordinates = object.getGeographicCoordinates();
        }
    }

    public static DefaultGCP castOrCopy(GCP object) {
        if (object == null || object instanceof DefaultGCP) {
            return (DefaultGCP)object;
        }
        return new DefaultGCP(object);
    }

    public DirectPosition getGeographicCoordinates() {
        return this.geographicCoordinates;
    }

    public void setGeographicCoordinates(DirectPosition newValue) {
        this.checkWritePermission(this.geographicCoordinates);
        this.geographicCoordinates = newValue;
    }

    @XmlElement(name="accuracyReport")
    public Collection<Element> getAccuracyReports() {
        this.accuracyReports = this.nonNullCollection(this.accuracyReports, Element.class);
        return this.accuracyReports;
    }

    public void setAccuracyReports(Collection<? extends Element> newValues) {
        this.accuracyReports = this.writeCollection(newValues, this.accuracyReports, Element.class);
    }
}

