/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gml;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.util.internal.shared.CodeLists;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.bind.Context;
import org.opengis.util.CodeList;

public abstract class CodeListAdapter<BoundType extends CodeList<BoundType>>
extends XmlAdapter<Value, BoundType> {
    protected CodeListAdapter() {
    }

    protected abstract Class<BoundType> getCodeListClass();

    protected String getCodeSpace() {
        return null;
    }

    public final BoundType unmarshal(Value identifier) {
        if (identifier != null) {
            try {
                return (BoundType)CodeLists.getOrCreate(this.getCodeListClass(), (String)identifier.value);
            }
            catch (RuntimeException e) {
                Context.warningOccured(Context.current(), CodeListAdapter.class, "unmarshal", e, true);
            }
        }
        return null;
    }

    public final Value marshal(BoundType code) {
        return code != null ? new Value(this.getCodeSpace(), (CodeList<?>)code) : null;
    }

    public static final class Value {
        @XmlAttribute
        public String codeSpace;
        @XmlValue
        public String value;

        public Value() {
        }

        Value(String codeSpace, CodeList<?> code) {
            this.codeSpace = codeSpace;
            this.value = Types.getCodeName(code);
        }
    }
}

